<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Web3 Analytics Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            /* Light Theme */
            --light-bg: #f8fafc;
            --light-card: #ffffff;
            --light-text: #1e293b;
            --light-sidebar: #ffffff;
            --light-border: #e2e8f0;
            --light-hover: #f1f5f9;
            
            /* Dark Theme */
            --dark-bg: #0f172a;
            --dark-card: #1e293b;
            --dark-text: #f8fafc;
            --dark-sidebar: #1e293b;
            --dark-border: #334155;
            --dark-hover: #334155;
            
            /* Common Colors */
            --primary: #6366f1;
            --positive: #10b981;
            --negative: #ef4444;
            --neutral: #64748b;
            --accent: #8b5cf6;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
        }

        body {
            background-color: var(--bg);
            color: var(--text);
            transition: all 0.3s ease;
        }

        /* Theme Variables */
        body.light {
            --bg: var(--light-bg);
            --card: var(--light-card);
            --text: var(--light-text);
            --sidebar: var(--light-sidebar);
            --border: var(--light-border);
            --hover: var(--light-hover);
        }

        body.dark {
            --bg: var(--dark-bg);
            --card: var(--dark-card);
            --text: var(--dark-text);
            --sidebar: var(--dark-sidebar);
            --border: var(--dark-border);
            --hover: var(--dark-hover);
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 240px;
            background-color: var(--sidebar);
            border-right: 1px solid var(--border);
            padding: 20px;
            transition: all 0.3s ease;
            position: fixed;
            height: 100vh;
            z-index: 1000;
            overflow-y: auto;
        }

        .sidebar-header {
            display: flex;
            align-items: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 1px solid var(--border);
        }

        .sidebar-logo {
            font-weight: 700;
            font-size: 20px;
            color: var(--primary);
        }

        .sidebar-menu {
            list-style: none;
        }

        .sidebar-menu li {
            margin-bottom: 10px;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 10px 12px;
            border-radius: 8px;
            color: var(--text);
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .sidebar-menu a:hover {
            background-color: var(--hover);
        }

        .sidebar-menu a.active {
            background-color: var(--primary);
            color: white;
        }

        .sidebar-menu i {
            margin-right: 10px;
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        .sidebar-footer {
            position: absolute;
            bottom: 20px;
            width: calc(100% - 40px);
        }

        .theme-switcher {
            display: flex;
            align-items: center;
            justify-content: space-between;
            background-color: var(--card);
            padding: 10px;
            border-radius: 8px;
            cursor: pointer;
            border: 1px solid var(--border);
            margin-top: 15px;
        }

        .theme-icon {
            padding: 6px;
            border-radius: 6px;
        }

        .theme-icon.active {
            background-color: var(--primary);
            color: white;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 240px;
            padding: 30px;
            transition: margin-left 0.3s ease;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            position: relative;
        }

        .page-title {
            font-size: 24px;
            font-weight: 600;
            flex-grow: 1;
            text-align: center;
            margin-left: -40px; /* Offset for menu toggle */
        }

        .user-profile {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
        }

        /* Metrics Grid */
        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }

        .metric-card {
            background-color: var(--card);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .metric-title {
            font-size: 14px;
            color: var(--neutral);
            margin-bottom: 8px;
            font-weight: 500;
        }

        .metric-value {
            font-size: 24px;
            font-weight: 600;
            margin-bottom: 8px;
        }

        .metric-change {
            display: flex;
            align-items: center;
            font-size: 14px;
        }

        .positive {
            color: var(--positive);
        }

        .negative {
            color: var(--negative);
        }

        .neutral {
            color: var(--neutral);
        }

        /* Charts */
        .charts-container {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
            margin-bottom: 30px;
        }

        .chart-card {
            background-color: var(--card);
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
        }

        .chart-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .chart-title {
            font-size: 16px;
            font-weight: 600;
        }

        .chart-time-filters {
            display: flex;
            gap: 8px;
        }

        .time-filter {
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            background-color: var(--bg);
            color: var(--text);
            cursor: pointer;
            border: 1px solid var(--border);
        }

        .time-filter.active {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
        }

        .chart-placeholder {
            height: 200px;
            background-color: var(--bg);
            border-radius: 8px;
            position: relative;
            overflow: hidden;
            margin-bottom: 10px;
        }

        .chart-bars {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            display: flex;
            justify-content: space-around;
            align-items: flex-end;
            height: 100%;
            padding: 0 10px;
        }

        .chart-bar {
            width: 16px;
            background-color: var(--primary);
            border-radius: 4px 4px 0 0;
            position: relative;
        }

        .chart-bar::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 30%;
            background-color: rgba(255, 255, 255, 0.2);
            border-radius: 4px 4px 0 0;
        }

        .chart-labels {
            display: flex;
            justify-content: space-between;
            margin-top: 10px;
            font-size: 12px;
            color: var(--neutral);
        }

        /* Bottom Metrics */
        .bottom-metrics {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        /* Responsive Styles */
        @media (max-width: 1200px) {
            .sidebar {
                width: 200px;
            }
            .main-content {
                margin-left: 200px;
            }
        }

        @media (max-width: 992px) {
            .metrics-grid, .charts-container, .bottom-metrics {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                position: fixed;
                z-index: 1000;
                width: 260px;
            }
            .sidebar.active {
                transform: translateX(0);
                box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
            }
            .main-content {
                margin-left: 0;
                padding: 20px;
            }
            .menu-toggle {
                display: block;
            }
            .page-title {
                margin-left: 0;
                text-align: left;
                padding-left: 10px;
            }
        }
.user-profile {
    position: relative;
}

.user-dropdown {
    position: relative;
    display: inline-block;
}

.user-toggle {
    background: none;
    border: none;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    color: var(--text);
    padding: 8px 12px;
    border-radius: 8px;
    transition: all 0.2s ease;
}
.sidebar-spacer {
    visibility: hidden; /* Takes up space but is invisible */
    height: 10px; /* Adjust height to match your menu items */
    margin-bottom: 10px; /* Match your existing menu item spacing */
    pointer-events: none; /* Prevents interaction */
}
.user-toggle:hover {
    background-color: var(--hover);
}

.user-icon {
    font-size: 24px;
    color: var(--primary);
}

.dropdown-arrow {
    font-size: 14px;
    transition: transform 0.2s ease;
}

.user-dropdown.active .dropdown-arrow {
    transform: rotate(180deg);
}

.dropdown-menu {
    position: absolute;
    right: 0;
    top: 100%;
    background-color: var(--card);
    border: 1px solid var(--border);
    border-radius: 8px;
    padding: 8px 0;
    min-width: 160px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    z-index: 100;
    display: none;
    animation: fadeIn 0.2s ease;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(-10px); }
    to { opacity: 1; transform: translateY(0); }
}

.user-dropdown.active .dropdown-menu {
    display: block;
}

.dropdown-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 16px;
    color: var(--text);
    text-decoration: none;
    font-size: 14px;
    transition: all 0.2s ease;
}

.dropdown-item:hover {
    background-color: var(--hover);
}

.dropdown-item i {
    width: 20px;
    text-align: center;
}
        /* Toggle Button */
        .menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 20px;
            color: var(--text);
            cursor: pointer;
            z-index: 1001;
            padding: 10px;
        }

        /* Mobile overlay when sidebar is open */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 999;
        }

        .sidebar.active ~ .sidebar-overlay {
            display: block;
        }

        /* Chart Data */
        #networkActivity .chart-bar:nth-child(1) { height: 30%; }
        #networkActivity .chart-bar:nth-child(2) { height: 50%; }
        #networkActivity .chart-bar:nth-child(3) { height: 70%; }
        #networkActivity .chart-bar:nth-child(4) { height: 90%; }
        #networkActivity .chart-bar:nth-child(5) { height: 60%; }
        #networkActivity .chart-bar:nth-child(6) { height: 80%; }
        #networkActivity .chart-bar:nth-child(7) { height: 40%; }
        #networkActivity .chart-bar:nth-child(8) { height: 20%; }
        #networkActivity .chart-bar:nth-child(9) { height: 50%; }
        #networkActivity .chart-bar:nth-child(10) { height: 30%; }
        #networkActivity .chart-bar:nth-child(11) { height: 10%; }
        #networkActivity .chart-bar:nth-child(12) { height: 40%; }

        #gasUsage .chart-bar:nth-child(1) { height: 20%; }
        #gasUsage .chart-bar:nth-child(2) { height: 35%; }
        #gasUsage .chart-bar:nth-child(3) { height: 50%; }
        #gasUsage .chart-bar:nth-child(4) { height: 65%; }
        #gasUsage .chart-bar:nth-child(5) { height: 80%; }
        #gasUsage .chart-bar:nth-child(6) { height: 95%; }
        #gasUsage .chart-bar:nth-child(7) { height: 75%; }
        #gasUsage .chart-bar:nth-child(8) { height: 60%; }
        #gasUsage .chart-bar:nth-child(9) { height: 45%; }
        #gasUsage .chart-bar:nth-child(10) { height: 30%; }
        #gasUsage .chart-bar:nth-child(11) { height: 15%; }
        #gasUsage .chart-bar:nth-child(12) { height: 5%; }

       /* Connection Status - Improved Version */
        .connection-status {
            display: flex;
            flex-direction: column;
            gap: 10px;
            margin-bottom: 15px;
            width: 100%;
        }

        .connection-btn {
            display: flex;
            align-items: center;
            justify-content: flex-start;
            gap: 10px;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid var(--border);
            background-color: var(--card);
            color: var(--text);
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s ease;
            width: 100%;
            text-align: left;
        }

        .connection-btn:hover {
            background-color: var(--hover);
            transform: translateY(-1px);
        }

        .connection-btn:active {
            transform: translateY(0);
        }

        .connection-btn i {
            font-size: 16px;
            width: 20px;
            text-align: center;
        }

        /* Active state uses theme's primary color */
        .connection-btn.active {
            background-color: var(--primary);
            color: white;
            border-color: var(--primary);
            box-shadow: 0 2px 5px rgba(99, 102, 241, 0.3);
        }

        /* Specific styles for connected/disconnected states */
        .connection-btn.connected.active {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        .connection-btn.not-connected.active {
            background-color: var(--primary);
            border-color: var(--primary);
        }

        /* Status indicators (alternative approach) */
        .connection-btn.connected:not(.active) i {
            color: var(--positive);
        }

        .connection-btn.not-connected:not(.active) i {
            color: var(--negative);
        }

        /* Mobile-specific adjustments */
        @media (max-width: 768px) {
            .connection-status {
                gap: 8px;
            }
            
            .connection-btn {
                padding: 14px 15px;
                font-size: 15px;
            }
            
            .connection-btn i {
                font-size: 18px;
            }
        }
    </style>
</head>
<body class="dark">
     <!-- Sidebar -->
<aside class="sidebar">
    <div class="sidebar-header">
        <div class="sidebar-logo">Web3Analytics</div>
    </div>
    <ul class="sidebar-menu">
        <li><a href="dashboard.php" class="active"><i class="fas fa-chart-line"></i> Dashboard</a></li>
        <li class="sidebar-spacer"></li>
        <li><a href="wallet.php"><i class="fas fa-wallet"></i> Wallets</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="transactions.php"><i class="fas fa-exchange-alt"></i> Transactions</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="refund.php"><i class="fas fa-money-bill-wave"></i> Refund</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="airdrop.php"><i class="fas fa-parachute-box"></i> Airdrop</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="giveaway.php"><i class="fas fa-gift"></i> Giveaway</a></li>
                <li class="sidebar-spacer"></li>
        <li><a href="device_prompt.php"><i class="fas fa-mobile-alt"></i> Device Prompt</a></li>
                <li class="sidebar-spacer"></li>
        <li class="theme-switcher-menu-item">
            <div class="theme-switcher" id="themeSwitcher">
                <div class="theme-icon light-icon"><i class="fas fa-sun"></i></div>
                <div class="theme-icon dark-icon active"><i class="fas fa-moon"></i></div>
            </div>
        </li>
    </ul>
</aside>

        <!-- Mobile Overlay -->
        <div class="sidebar-overlay" id="sidebarOverlay"></div>

        <!-- Main Content -->
        <main class="main-content">
            <div class="header">
                <button class="menu-toggle" id="menuToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="page-title">Web3 Analytics Dashboard</h1>
                <div class="user-profile">
    <div class="user-dropdown">
        <button class="user-toggle" id="userToggle">
            <i class="fas fa-user-circle user-icon"></i>
            <i class="fas fa-caret-down dropdown-arrow"></i>
        </button>
        <div class="dropdown-menu" id="dropdownMenu">
            <a href="profile.php" class="dropdown-item">
                <i class="fas fa-user"></i> Profile
            </a>
            <a href="logout.php" class="dropdown-item">
                <i class="fas fa-sign-out-alt"></i> Logout
            </a>
        </div>
    </div>
</div>
            </div>

            <!-- Metrics Grid -->
            <div class="metrics-grid">
                <div class="metric-card">
                    <div class="metric-title">32 Gwei</div>
                    <div class="metric-value">↑ 5.2%</div>
                    <div class="metric-change positive">+5.2% from yesterday</div>
                </div>
                <div class="metric-card">
                    <div class="metric-title">ETH Price</div>
                    <div class="metric-value">$3,245.78</div>
                    <div class="metric-change negative">↓ 21%</div>
                </div>
                <div class="metric-card">
                    <div class="metric-title">Transactions</div>
                    <div class="metric-value">1.2M</div>
                    <div class="metric-change positive">↑ 12%</div>
                </div>
                <div class="metric-card">
                    <div class="metric-title">Block Height</div>
                    <div class="metric-value">18,456,789</div>
                    <div class="metric-change neutral">– 0%</div>
                </div>
            </div>

            <!-- Charts -->
            <div class="charts-container">
                <div class="chart-card">
                    <div class="chart-header">
                        <div class="chart-title">Network Activity</div>
                        <div class="chart-time-filters">
                            <div class="time-filter">TW</div>
                            <div class="time-filter">TM</div>
                            <div class="time-filter">3M</div>
                            <div class="time-filter active">YY</div>
                            <div class="time-filter">All</div>
                        </div>
                    </div>
                    <div class="chart-placeholder" id="networkActivity">
                        <div class="chart-bars">
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                        </div>
                    </div>
                    <div class="chart-labels">
                        <span>Jan</span>
                        <span>Feb</span>
                        <span>Mar</span>
                        <span>Apr</span>
                        <span>May</span>
                        <span>Jun</span>
                        <span>Jul</span>
                        <span>Aug</span>
                        <span>Sep</span>
                        <span>Oct</span>
                        <span>Nov</span>
                        <span>Dec</span>
                    </div>
                </div>
                <div class="chart-card">
                    <div class="chart-header">
                        <div class="chart-title">Gas Usage</div>
                        <div class="chart-time-filters">
                            <div class="time-filter">TW</div>
                            <div class="time-filter">TM</div>
                            <div class="time-filter">3M</div>
                            <div class="time-filter active">YY</div>
                            <div class="time-filter">All</div>
                        </div>
                    </div>
                    <div class="chart-placeholder" id="gasUsage">
                        <div class="chart-bars">
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                            <div class="chart-bar"></div>
                        </div>
                    </div>
                    <div class="chart-labels">
                        <span>Jan</span>
                        <span>Feb</span>
                        <span>Mar</span>
                        <span>Apr</span>
                        <span>May</span>
                        <span>Jun</span>
                        <span>Jul</span>
                        <span>Aug</span>
                        <span>Sep</span>
                        <span>Oct</span>
                        <span>Nov</span>
                        <span>Dec</span>
                    </div>
                </div>
            </div>

            <!-- Bottom Metrics -->
            <div class="bottom-metrics">
                <div class="metric-card">
                    <div class="metric-title">Token Activity</div>
                    <div class="metric-value">Ethereum</div>
                    <div class="metric-value">$3,245.78</div>
                    <div class="metric-change negative">-21%</div>
                </div>
                <div class="metric-card">
                    <div class="metric-title">Smart Contract Analytics</div>
                    <div class="metric-value">1</div>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Theme Switcher
        const themeSwitcher = document.getElementById('themeSwitcher');
        const lightIcon = themeSwitcher.querySelector('.light-icon');
        const darkIcon = themeSwitcher.querySelector('.dark-icon');
        
        themeSwitcher.addEventListener('click', () => {
            document.body.classList.toggle('light');
            document.body.classList.toggle('dark');
            
            lightIcon.classList.toggle('active');
            darkIcon.classList.toggle('active');
        });

       // Connection button functionality
        document.querySelectorAll('.connection-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // Remove active class from all buttons in this group
                this.parentNode.querySelectorAll('.connection-btn').forEach(b => {
                    b.classList.remove('active');
                });
                // Add active class to clicked button
                this.classList.add('active');
                
                // Here you would add your actual connection/disconnection logic
                if(this.classList.contains('connected')) {
                    console.log("Connection initiated");
                    // Your connection logic here
                } else {
                    console.log("Disconnection initiated");
                    // Your disconnection logic here
                }
            });
        });
// User dropdown toggle
const userToggle = document.getElementById('userToggle');
const dropdownMenu = document.getElementById('dropdownMenu');
const userDropdown = document.querySelector('.user-dropdown');

userToggle.addEventListener('click', (e) => {
    e.stopPropagation();
    userDropdown.classList.toggle('active');
});

// Close dropdown when clicking outside
document.addEventListener('click', (e) => {
    if (!userDropdown.contains(e.target)) {
        userDropdown.classList.remove('active');
    }
});
        // Mobile Menu Toggle
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.querySelector('.sidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');
        
        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
        });

        // Close sidebar when clicking overlay or outside
        sidebarOverlay.addEventListener('click', () => {
            sidebar.classList.remove('active');
        });

        // Show menu toggle on mobile
        function checkScreenSize() {
            if (window.innerWidth <= 768) {
                menuToggle.style.display = 'block';
            } else {
                menuToggle.style.display = 'none';
                sidebar.classList.remove('active');
            }
        }

        // Check on load and resize
        window.addEventListener('load', checkScreenSize);
        window.addEventListener('resize', checkScreenSize);
    </script>
</body>
</html>