<?php
session_start();

// Verify admin is logged in
if (!isset($_SESSION['admin_id']) || empty($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit();
}


// Include the database configuration
include($_SERVER['DOCUMENT_ROOT'] . '/config.php');


// Fetch all transactions
$transactionHistoryQuery = $conn->prepare("SELECT t.*, u.username FROM payee_transactions t
                                            LEFT JOIN users u ON t.user_id = u.id
                                            ORDER BY t.date DESC");
$transactionHistoryQuery->execute();
$transactionHistory = $transactionHistoryQuery->fetchAll(PDO::FETCH_ASSOC);

// Handle update status and date form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_transaction'])) {
    if (isset($_POST['transaction_id'], $_POST['new_status'], $_POST['new_date'])) {
        $transactionId = $_POST['transaction_id'];
        $newStatus = $_POST['new_status'];
        $newDate = $_POST['new_date'];

        // Update status and date in the database
        $updateQuery = $conn->prepare("UPDATE payee_transactions SET status = :status, date = :date WHERE id = :transaction_id");
        $updateQuery->execute([
            ':status' => $newStatus,
            ':date' => $newDate,
            ':transaction_id' => $transactionId,
        ]);

        $message = "Transaction updated successfully!";
        header("Refresh: 2;"); // Refresh the page to see changes
    }
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
     <style>
       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            display: flex;
            flex-direction: row;
            min-height: 100vh;
            background-color: #f7f7f7;
        }

        /* Sidebar */
        .sidebar {
            background-color: #c70000;
            color: #fff;
            width: 250px;
            padding: 20px;
            position: fixed;
            top: 0;
            bottom: 0;
            left: -250px;
            transition: transform 0.3s ease-in-out;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto; /* Enable scrolling */
            height: 100%; /* Make sure sidebar fills the screen */
        }

        .sidebar.active {
            transform: translateX(250px);
        }

        .sidebar .profile {
            text-align: center;
            margin-bottom: 30px;
        }

        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .sidebar .profile h3 {
            font-size: 18px;
            margin-bottom: 5px;
        }

        .sidebar .profile p {
            font-size: 14px;
            color: #ddd;
        }

        .sidebar ul {
            list-style: none;
            margin-top: auto;
            margin-bottom: auto;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 20px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        .sidebar ul li a i {
            font-size: 20px;
        }

        .sidebar ul li a:hover {
            background-color: #a00000;
        }

        /* Navbar */
        .navbar {
            background-color: #c70000;
            color: #fff;
            padding: 10px 20px;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar .menu-toggle {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .icons {
            display: flex;
            gap: 15px;
        }

        .navbar .icons i {
            font-size: 24px;
            cursor: pointer;
        }

       .container {
        padding: 20px;
        margin: 0 auto;
    }

   
    .container {
        padding: 20px;
        margin: 0 auto;
    }

    h1 {
        text-align: center;
        font-size: 2rem;
        color: #333;
        margin-bottom: 30px;
    }

    

    @media (max-width: 768px) {
        .account-card {
            flex: 1 1 100%; /* Stacks cards on mobile */
            max-width: 100%;
        }

        h1 {
            font-size: 1.5rem;
        }
    }

    /* Utility Styles */
    .currency div:first-child {
        font-weight: bold;
    }
    </style>
</head>
<body>
 <div class="sidebar" id="sidebar">
        <div class="profile">
            <img src="/assets/default-profile.png" alt="User Profile">
        </div>
        <ul>
            <li><a href="/admin/admin_dashboard.php"><i class="fas fa-tachometer-alt"></i>Dashboard</a></li>
            <li><a href="/admin/manage_users.php"><i class="fas fa-user"></i>Manage Users</a></li>
            <li><a href="/admin/bsb.php"><i class="fas fa-list"></i>Bsb & Account Number</a></li>
            <li><a href="/admin/transfer-request.php"><i class="fas fa-paper-plane"></i>Manage Transfers</a></li>
            <li><a href="/admin/update_bills.php"><i class="fas fa-list"></i>Update Bills</a></li>
             <li><a href="/admin/update_accountstatement.php"><i class="fas fa-money-check-alt"></i>Update Account Statements</a></li>
             <li><a href="/admin/manage_cards.php"><i class="fas fa-hand-holding-usd"></i>Manage Cards</a></li>
            <li><a href="/admin/transfer_date.php"><i class="fas fa-paper-plane"></i>Update Transactions Date</a></li>
            <li><a href="/admin/deposit_requests.php"><i class="fas fa-money-check-alt"></i>Manage Deposits</a></li>
            <li><a href="/admin/update_balance.php"><i class="fas fa-file-invoice-dollar"></i>Update Balances</a></li>
            <li><a href="/admin/kyc-request.php"><i class="fas fa-id-card"></i>Manage KYC</a></li>
            <li><a href="/admin/admin_loans.php"><i class="fas fa-hand-holding-usd"></i>Manage Loan Credit</a></li>
            <li><a href="/admin/admin_send_notification.php"><i class="fas fa-bell"></i>Manage Notifications</a></li>
           <li><a href="/admin/logout.php"><i class="fas fa-sign-out"></i>Sign Out</a></li>
            <li><a href="#"><i class=""></i></a></li>
        </ul>
    </div>

    <div class="navbar">
        <i class="fas fa-bars menu-toggle" id="menuToggle"></i>
        <span>Admin Dashboard</span>
        <div class="icons">
            <i class="fas fa-bell"></i>
            <i class="fas fa-user-circle"></i>
        </div>
    </div>
    <div class="container">
    <h1></h1>
    
    <h1>Admin Dashboard - Manage Transactions</h1>
    <?php if (isset($message)) { echo "<p>$message</p>"; } ?>

    <!-- Loop through the transaction history and display as cards on mobile -->
    <?php foreach ($transactionHistory as $transaction): ?>
        <div class="transaction-card">
            <h3>Transaction ID: <?= htmlspecialchars($transaction['id']) ?></h3>
            <p><strong>User:</strong> <?= htmlspecialchars($transaction['username']) ?></p>
            <p><strong>Biller ID:</strong> <?= htmlspecialchars($transaction['biller_id']) ?></p>
            <p><strong>Company/Payee:</strong> <?= htmlspecialchars($transaction['company_name']) ?></p>
            <p><strong>Amount:</strong> $<?= number_format($transaction['amount'], 2) ?></p>
            <p><strong>Status:</strong> <?= htmlspecialchars($transaction['status']) ?></p>
            <p><strong>Date:</strong> <?= htmlspecialchars($transaction['date']) ?></p>

            <!-- Form for updating the status and date -->
            <form method="POST">
                <input type="hidden" name="transaction_id" value="<?= htmlspecialchars($transaction['id']) ?>">

                <label for="new_status">Status:</label>
                <select name="new_status">
                    <option value="Pending" <?= $transaction['status'] === 'Pending' ? 'selected' : '' ?>>Pending</option>
                    <option value="Processing" <?= $transaction['status'] === 'Processing' ? 'selected' : '' ?>>Processing</option>
                    <option value="Completed" <?= $transaction['status'] === 'Completed' ? 'selected' : '' ?>>Completed</option>
                    <option value="Failed" <?= $transaction['status'] === 'Failed' ? 'selected' : '' ?>>Failed</option>
                </select><br>

                <label for="new_date">Date:</label>
                <input type="datetime-local" name="new_date" value="<?= htmlspecialchars($transaction['date']) ?>"><br>

                <button type="submit" name="update_transaction">Update</button>
            </form>
        </div>
    <?php endforeach; ?>

<!-- Mobile Responsive Styles -->
 <style>
       
 body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
        }
        h1 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table, th, td {
            border: 1px solid #ddd;
        }

        th, td {
            padding: 12px;
            text-align: left;
        }

        th {
            background-color: #4CAF50;
            color: white;
        }

        td {
            background-color: #f9f9f9;
        }

        td form {
            display: flex;
            flex-direction: column;
        }

        td form label {
            margin-bottom: 5px;
        }

        td form select, td form input, td form button {
            margin-bottom: 10px;
        }

        td form button {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 8px 16px;
            cursor: pointer;
        }

        td form button:hover {
            background-color: #45a049;
        }

        /* Card Styles for Mobile */
        .transaction-card {
            border: 1px solid #ddd;
            background-color: #fff;
            margin-bottom: 15px;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .transaction-card h3 {
            margin-top: 0;
            color: #4CAF50;
        }

        .transaction-card p {
            margin: 5px 0;
        }

        .transaction-card label {
            font-weight: bold;
        }

        .transaction-card select, .transaction-card input, .transaction-card button {
            margin-bottom: 10px;
            width: 100%;
        }

        .transaction-card button {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px;
            cursor: pointer;
        }

        .transaction-card button:hover {
            background-color: #45a049;
        }

        /* Responsive Styles */
        @media screen and (min-width: 769px) {
            table {
                width: 100%;
                overflow-x: auto;
                display: block;
            }

            th, td {
                padding: 10px;
                font-size: 14px;
            }

            td form {
                display: block;
                width: 100%;
            }

            td form label, td form select, td form input, td form button {
                width: 100%;
                margin-bottom: 10px;
            }

            td form button {
                width: auto;
                margin-top: 10px;
            }
        }

        /* Mobile adjustments */
        @media screen and (max-width: 768px) {
            table {
                display: none; /* Hide the table on mobile */
            }

            .transaction-card {
                margin-bottom: 20px;
            }
        }
    </style>

    
    <script>
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const content = document.getElementById('content');

        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
            content.classList.toggle('shrink');
        });
    </script>
</body>
</html>
