<?php
require_once($_SERVER['DOCUMENT_ROOT'] . '/config.php');

try {
    // Test simple query
    $stmt = $conn->query("SELECT id, username FROM admins LIMIT 1");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<h2>Connection Successful!</h2>";
    echo "<pre>First admin user: " . print_r($result, true) . "</pre>";
    
    // Test password functions
    $test_pass = 'test123';
    $hashed = password_hash($test_pass, PASSWORD_DEFAULT);
    echo "<p>Password function test: " . (password_verify($test_pass, $hashed) ? "Working" : "Failed") . "</p>";
    
} catch (PDOException $e) {
    echo "<h2>Connection Failed</h2>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<p>Check your config.php credentials and database permissions.</p>";
    error_log("Connection Test Failed: " . $e->getMessage());
}
?>