<?php 
// Include database connection
require_once($_SERVER['DOCUMENT_ROOT'] . '/config.php');
session_start();

// Check if the user is an admin
if (!isset($_SESSION['admin_id']) || empty($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit();
}

// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    // Fetch all users
    $userStmt = $conn->query("SELECT id, username FROM users");
    $users = $userStmt->fetchAll(PDO::FETCH_ASSOC);

    // Handle form submission
    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        if (
            isset($_POST['user_id'], $_POST['card_number'], $_POST['cardholder_name'], 
                  $_POST['expiry_date'], $_POST['card_type'], $_POST['bank_name'])
        ) {
            $user_id = intval($_POST['user_id']);
            $card_number = htmlspecialchars(trim($_POST['card_number']));
            $cardholder_name = htmlspecialchars(trim($_POST['cardholder_name']));
            $expiry_date = htmlspecialchars(trim($_POST['expiry_date']));
            $card_type = htmlspecialchars(trim($_POST['card_type']));
            $bank_name = htmlspecialchars(trim($_POST['bank_name']));

            // Validate that the user ID exists in the database
            $checkUserStmt = $conn->prepare("SELECT id FROM users WHERE id = :user_id");
            $checkUserStmt->execute([':user_id' => $user_id]);
            if ($checkUserStmt->rowCount() === 0) {
                die("Invalid user ID.");
            }

            // Insert data securely
            $stmt = $conn->prepare("
                INSERT INTO card_details (user_id, card_number, cardholder_name, expiry_date, card_type, bank_name) 
                VALUES (:user_id, :card_number, :cardholder_name, :expiry_date, :card_type, :bank_name)
            ");
            $stmt->execute([ 
                ':user_id' => $user_id,
                ':card_number' => $card_number,
                ':cardholder_name' => $cardholder_name,
                ':expiry_date' => $expiry_date,
                ':card_type' => $card_type,
                ':bank_name' => $bank_name,
            ]);

            // Success message
            echo "<p style='color: green;'>Card details successfully added!</p>";
        } else {
            die("All fields are required.");
        }
    }

    // Fetch all cards with user info
    $stmt = $conn->query("SELECT c.*, u.username FROM card_details c JOIN users u ON c.user_id = u.id");
    $cards = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("Database error: " . $e->getMessage());
    die("A database error occurred. Please try again later.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
     <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
     <style>
       * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Roboto', sans-serif;
        }

        body {
            display: flex;
            flex-direction: row;
            min-height: 100vh;
            background-color: #f7f7f7;
        }

        /* Sidebar */
        .sidebar {
            background-color: #c70000;
            color: #fff;
            width: 250px;
            padding: 20px;
            position: fixed;
            top: 0;
            bottom: 0;
            left: -250px;
            transition: transform 0.3s ease-in-out;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto; /* Enable scrolling */
            height: 100%; /* Make sure sidebar fills the screen */
        }

        .sidebar.active {
            transform: translateX(250px);
        }

        .sidebar .profile {
            text-align: center;
            margin-bottom: 30px;
        }

        .sidebar .profile img {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            margin-bottom: 10px;
        }

        .sidebar .profile h3 {
            font-size: 18px;
            margin-bottom: 5px;
        }

        .sidebar .profile p {
            font-size: 14px;
            color: #ddd;
        }

        .sidebar ul {
            list-style: none;
            margin-top: auto;
            margin-bottom: auto;
            width: 100%;
        }

        .sidebar ul li {
            margin-bottom: 20px;
        }

        .sidebar ul li a {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #fff;
            text-decoration: none;
            font-size: 16px;
            padding: 10px;
            border-radius: 5px;
            transition: background-color 0.3s;
        }

        .sidebar ul li a i {
            font-size: 20px;
        }

        .sidebar ul li a:hover {
            background-color: #a00000;
        }

        /* Navbar */
        .navbar {
            background-color: #c70000;
            color: #fff;
            padding: 10px 20px;
            width: 100%;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .navbar .menu-toggle {
            font-size: 24px;
            cursor: pointer;
        }

        .navbar .icons {
            display: flex;
            gap: 15px;
        }

        .navbar .icons i {
            font-size: 24px;
            cursor: pointer;
        }

       .container {
        padding: 20px;
        margin: 0 auto;
    }

   
    .container {
        padding: 20px;
        margin: 0 auto;
    }

    h1 {
        text-align: center;
        font-size: 2rem;
        color: #333;
        margin-bottom: 30px;
    }

    

    @media (max-width: 768px) {
        .account-card {
            flex: 1 1 100%; /* Stacks cards on mobile */
            max-width: 100%;
        }

        h1 {
            font-size: 1.5rem;
        }
    }

    /* Utility Styles */
    .currency div:first-child {
        font-weight: bold;
    }
    </style>
</head>
<body>
 <div class="sidebar" id="sidebar">
        <div class="profile">
            <img src="/assets/default-profile.png" alt="User Profile">
        </div>
        <ul>
            <li><a href="/admin/admin_dashboard.php"><i class="fas fa-tachometer-alt"></i>Dashboard</a></li>
            <li><a href="/admin/manage_users.php"><i class="fas fa-user"></i>Manage Users</a></li>
            <li><a href="/admin/bsb.php"><i class="fas fa-list"></i>Bsb & Account Number</a></li>
            <li><a href="/admin/transfer-request.php"><i class="fas fa-paper-plane"></i>Manage Transfers</a></li>
            <li><a href="/admin/update_bills.php"><i class="fas fa-list"></i>Update Bills</a></li>
             <li><a href="/admin/update_accountstatement.php"><i class="fas fa-money-check-alt"></i>Update Account Statements</a></li>
             <li><a href="/admin/manage_cards.php"><i class="fas fa-hand-holding-usd"></i>Manage Cards</a></li>
            <li><a href="/admin/transfer_date.php"><i class="fas fa-paper-plane"></i>Update Transactions Date</a></li>
            <li><a href="/admin/deposit_requests.php"><i class="fas fa-money-check-alt"></i>Manage Deposits</a></li>
            <li><a href="/admin/update_balance.php"><i class="fas fa-file-invoice-dollar"></i>Update Balances</a></li>
            <li><a href="/admin/kyc-request.php"><i class="fas fa-id-card"></i>Manage KYC</a></li>
            <li><a href="/admin/admin_loans.php"><i class="fas fa-hand-holding-usd"></i>Manage Loan Credit</a></li>
            <li><a href="/admin/admin_send_notification.php"><i class="fas fa-bell"></i>Manage Notifications</a></li>
           <li><a href="/admin/logout.php"><i class="fas fa-sign-out"></i>Sign Out</a></li>
            <li><a href="#"><i class=""></i></a></li>
        </ul>
    </div>


    <div class="navbar">
        <i class="fas fa-bars menu-toggle" id="menuToggle"></i>
        <span>Admin Dashboard</span>
        <div class="icons">
            <i class="fas fa-bell"></i>
            <i class="fas fa-user-circle"></i>
        </div>
    </div>
    <div class="container">
    <h1></h1>
    <h2>Add New Card</h2>
    <div class="form-container">
        <form method="POST">
            <label for="user_id">Select User:</label>
            <select name="user_id" required>
                <?php foreach ($users as $user) { ?>
                    <option value="<?php echo $user['id']; ?>"><?php echo htmlspecialchars($user['username']); ?></option>
                <?php } ?>
            </select>
            <input type="text" name="card_number" placeholder="Card Number" required>
            <input type="text" name="cardholder_name" placeholder="Cardholder Name" required>
            <input type="text" name="expiry_date" placeholder="Expiry Date (MM/YY)" required>
            <input type="text" name="card_type" placeholder="Card Type (Debit/Credit)" required>
            <input type="text" name="bank_name" placeholder="Bank Name" required>
            <button type="submit">Add Card</button>
        </form>
    </div>

    <h2>Card List</h2>
    <div class="card-list">
        <?php foreach ($cards as $card) { ?>
            <div class="card">
                <h3><?php echo htmlspecialchars($card['username']); ?></h3>
                <p><strong>Card Number:</strong> <?php echo htmlspecialchars($card['card_number']); ?></p>
                <p><strong>Cardholder Name:</strong> <?php echo htmlspecialchars($card['cardholder_name']); ?></p>
                <p><strong>Expiry Date:</strong> <?php echo htmlspecialchars($card['expiry_date']); ?></p>
                <p><strong>Card Type:</strong> <?php echo htmlspecialchars($card['card_type']); ?></p>
                <p><strong>Bank Name:</strong> <?php echo htmlspecialchars($card['bank_name']); ?></p>
            </div>
        <?php } ?>
    </div>
<!-- Mobile Responsive Styles -->
<style>
        /* General styling */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }

        h2 {
            text-align: center;
            color: #333;
        }

        .form-container {
            max-width: 600px;
            margin: 0 auto 30px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
        }

        .form-container label,
        .form-container input,
        .form-container select,
        .form-container button {
            width: 100%;
            padding: 10px;
            margin: 10px 0;
            font-size: 16px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }

        .form-container button {
            background-color: #c70000;
            color: white;
            cursor: pointer;
            font-weight: bold;
        }

        .form-container button:hover {
            background-color: #45a049;
        }

        /* Card list styling */
        .card-list {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            justify-content: center;
        }

        .card {
            background-color: white;
            padding: 20px;
            width: 250px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }

        .card:hover {
            transform: translateY(-10px);
        }

        .card h3 {
            text-align: center;
            margin: 0;
            font-size: 18px;
        }

        .card p {
            margin: 5px 0;
            color: #666;
            font-size: 14px;
        }

        .card p strong {
            font-weight: bold;
        }

        /* Responsive styling */
        @media (max-width: 768px) {
            .card {
                width: 100%;
                max-width: 300px;
            }
        }
    </style>
    
    <script>
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const content = document.getElementById('content');

        menuToggle.addEventListener('click', () => {
            sidebar.classList.toggle('active');
            content.classList.toggle('shrink');
        });
    </script>
</body>
</html>
