<?php
session_start();
if (!isset($_SESSION['admin_logged_in'])) {
    die('Unauthorized');
}

include($_SERVER['DOCUMENT_ROOT'] . '/config.php');

$orderId = $_GET['order_id'];

// Get order details
$orderQuery = "SELECT crypto_orders.*, users.username, users.email, users.account_number 
               FROM crypto_orders 
               JOIN users ON crypto_orders.user_id = users.id
               WHERE order_id = ?";
$orderStmt = $conn->prepare($orderQuery);
$orderStmt->execute([$orderId]);
$order = $orderStmt->fetch(PDO::FETCH_ASSOC);

// Get user balances
$balanceQuery = "SELECT balance, btc_balance, eth_balance, usdt_balance, usdc_balance 
                 FROM users WHERE id = ?";
$balanceStmt = $conn->prepare($balanceQuery);
$balanceStmt->execute([$order['user_id']]);
$balances = $balanceStmt->fetch(PDO::FETCH_ASSOC);

// Format response
$html = '
<div class="detail-row">
    <span class="detail-label">Order ID:</span>
    <span id="detail-id" class="detail-value">'.$order['order_id'].'</span>
</div>
<div class="detail-row">
    <span class="detail-label">User:</span>
    <span id="detail-user" class="detail-value">'.$order['username'].'</span>
</div>
<div class="detail-row">
    <span class="detail-label">Type:</span>
    <span id="detail-type" class="detail-value badge badge-'.$order['order_type'].'">'.ucfirst($order['order_type']).'</span>
</div>
<div class="detail-row">
    <span class="detail-label">Coin:</span>
    <span id="detail-coin" class="detail-value">'.strtoupper(str_replace('-', '', $order['coin_name'])).'</span>
</div>
<div class="detail-row">
    <span class="detail-label">Amount (USD):</span>
    <span id="detail-amount" class="detail-value">$'.number_format($order['total_price'], 2).'</span>
</div>
<div class="detail-row">
    <span class="detail-label">Crypto Amount:</span>
    <span id="detail-crypto-amount" class="detail-value">'.number_format($order['amount'], 8).' '.strtoupper(str_replace('-', '', $order['coin_name'])).'</span>
</div>
<div class="detail-row">
    <span class="detail-label">Status:</span>
    <span id="detail-status" class="detail-value badge badge-'.$order['status'].'">'.ucfirst($order['status']).'</span>
</div>
<div class="detail-row">
    <span class="detail-label">Date:</span>
    <span id="detail-date" class="detail-value">'.date('M d, Y H:i', strtotime($order['created_at'])).'</span>
</div>

<div class="status-controls">
    <h3>Update Status</h3>
    <select id="new-status">
        <option value="pending" '.($order['status'] == 'pending' ? 'selected' : '').'>Pending</option>
        <option value="completed" '.($order['status'] == 'completed' ? 'selected' : '').'>Completed</option>
        <option value="rejected" '.($order['status'] == 'rejected' ? 'selected' : '').'>Rejected</option>
    </select>
    <textarea id="admin-notes" placeholder="Admin notes...">'.htmlspecialchars($order['admin_notes'] ?? '').'</textarea>
    <button id="update-status" class="btn btn-primary">Update Status</button>
</div>

<div class="user-info">
    <h3>User Information</h3>
    <div class="detail-row">
        <span class="detail-label">Email:</span>
        <span id="user-email" class="detail-value">'.$order['email'].'</span>
    </div>
    <div class="detail-row">
        <span class="detail-label">Account Number:</span>
        <span id="user-account" class="detail-value">'.$order['account_number'].'</span>
    </div>
    <div class="detail-row">
        <span class="detail-label">Current Balances:</span>
        <div id="user-balances" class="balances-grid">
            <div><span>USD:</span> $'.number_format($balances['balance'], 2).'</div>
            <div><span>BTC:</span> '.number_format($balances['btc_balance'], 8).'</div>
            <div><span>ETH:</span> '.number_format($balances['eth_balance'], 8).'</div>
            <div><span>USDT:</span> '.number_format($balances['usdt_balance'], 8).'</div>
            <div><span>USDC:</span> '.number_format($balances['usdc_balance'], 8).'</div>
        </div>
    </div>
</div>';

echo $html;
?>