<?php
session_start();
include($_SERVER['DOCUMENT_ROOT'] . '/config.php'); // Ensure this path is correct

// Verify admin is logged in
if (!isset($_SESSION['admin_id']) || empty($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit();
}
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Handle status updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['deposit_id'], $_POST['status'])) {
    $stmt = $conn->prepare("UPDATE deposit_checks SET status = ? WHERE id = ?");
    $stmt->execute([$_POST['status'], $_POST['deposit_id']]);

    // If completed, you can perform any other logic here
    // For now, we won't update any account balances since there's no accounts table
    if ($_POST['status'] === 'completed') {
        // You can add a log entry or notification instead if needed
        // or just leave it blank
    }

   header('Location: /admin/deposit_requests.php');
exit;
}

// Get all pending deposits
$stmt = $conn->prepare("
    SELECT d.*, u.username 
    FROM deposit_checks d 
    JOIN users u ON d.user_id = u.id 
    ORDER BY d.created_at DESC
");
$stmt->execute();
$deposits = $stmt->fetchAll();
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }

        :root {
            --sidebar-bg: #14213d;
            --sidebar-text: #a8b2d1;
            --sidebar-hover: #1a2c5b;
            --active-link: #2a4494;
            --primary-text: #333;
            --secondary-text: #777;
            --card-bg: #fff;
            --main-bg: #f0f2f5;
            --deposit-color: #3498db;
            --withdraw-color: #e74c3c;
            --button-color: #0d6efd;
            --hover-color: #0b5ed7;
        }

        body {
            display: flex;
            background-color: var(--main-bg);
            min-height: 100vh;
        }

        /* Mobile nav toggle */
        .mobile-nav-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1050;
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            width: 40px;
            height: 40px;
            border-radius: 4px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: none;
            font-size: 20px;
        }

        /* Overlay for mobile */
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 900;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 250px;
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            height: 100vh;
            position: fixed;
            transition: all 0.3s ease;
            overflow-y: auto;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 20px;
            font-size: 18px;
            font-weight: bold;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-menu {
            margin-top: 20px;
        }

        .section-title {
            padding: 10px 20px;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #8a94a7;
            margin-top: 10px;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            text-decoration: none;
            color: var(--sidebar-text);
            transition: all 0.3s ease;
        }

        .menu-item:hover {
            background-color: var(--sidebar-hover);
        }

        .menu-item.active {
            background-color: var(--active-link);
            color: white;
        }

        .menu-item i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
            width: calc(100% - 250px);
            transition: all 0.3s ease;
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .page-icon {
            font-size: 20px;
            color: var(--primary-text);
        }

        .user-info {
            display: flex;
            align-items: center;
        }

        .user-icon {
            width: 32px;
            height: 32px;
            background-color: var(--button-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            margin-right: 10px;
        }

        .user-role {
            display: flex;
            flex-direction: column;
        }

        .role-name {
            font-size: 12px;
            color: var(--secondary-text);
        }

        /* Overview Section */
        .overview-section {
            margin-bottom: 30px;
        }

        .overview-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .overview-title {
            font-size: 24px;
            font-weight: 500;
            color: var(--primary-text);
        }

        .overview-description {
            font-size: 14px;
            color: var(--secondary-text);
            margin-top: 5px;
        }

        .view-users-btn {
            padding: 8px 16px;
            background-color: var(--button-color);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: background-color 0.3s;
        }

        .view-users-btn:hover {
            background-color: var(--hover-color);
        }

        .view-users-btn i {
            margin-right: 6px;
        }

        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .card {
            background-color: var(--card-bg);
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 20px;
            position: relative;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .card-title {
            font-size: 16px;
            color: var(--primary-text);
        }

        .card-icon {
            font-size: 14px;
            color: var(--secondary-text);
            cursor: pointer;
        }

        .card-amount {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .deposit-bar {
            height: 4px;
            width: 100%;
            background-color: var(--deposit-color);
            border-radius: 2px;
        }

        .withdraw-bar {
            height: 4px;
            width: 100%;
            background-color: var(--withdraw-color);
            border-radius: 2px;
        }

        /* Stats Card */
        .stats-card {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .stat-item {
            margin-bottom: 15px;
        }

        .stat-label {
            display: flex;
            align-items: center;
            margin-bottom: 5px;
            font-size: 14px;
            color: var(--secondary-text);
        }

        .stat-label-circle {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-right: 8px;
        }

        .deposit-circle {
            background-color: #f39c12;
        }

        .withdraw-circle {
            background-color: #e74c3c;
        }

        .transaction-circle {
            background-color: #9b59b6;
        }

        .users-circle {
            background-color: #3498db;
        }

        .stat-value {
            font-size: 24px;
            font-weight: 500;
        }

        /* Footer */
        .footer {
            font-size: 12px;
            color: var(--secondary-text);
            margin-top: 40px;
            padding-top: 10px;
            border-top: 1px solid #eee;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .sidebar {
                width: 80px;
            }
            .sidebar-header {
                padding: 15px 10px;
                text-align: center;
                font-size: 14px;
            }
            .menu-item span, .section-title {
                display: none;
            }
            .menu-item {
                justify-content: center;
                padding: 15px 0;
            }
            .menu-item i {
                margin-right: 0;
                font-size: 18px;
            }
            .main-content {
                margin-left: 80px;
                width: calc(100% - 80px);
            }
        }

        @media (max-width: 768px) {
            .cards-grid {
                grid-template-columns: 1fr;
            }
            .stats-card {
                grid-template-columns: 1fr;
            }
            .mobile-nav-toggle {
                display: flex;
            }
            .sidebar {
                transform: translateX(-100%);
                width: 250px;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .menu-item span, .section-title {
                display: block;
            }
            .menu-item {
                justify-content: flex-start;
                padding: 12px 20px;
            }
            .menu-item i {
                margin-right: 10px;
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding-top: 60px;
            }
            .overlay.active {
                display: block;
            }
        }

        @media (max-width: 576px) {
            .overview-header {
                flex-direction: column;
                align-items: flex-start;
            }
            .view-users-btn {
                margin-top: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Mobile menu toggle -->
    <button class="mobile-nav-toggle" id="navToggle">
        <i class="fas fa-bars"></i>
    </button>

            <!-- Overlay for closing the sidebar on mobile -->
    <div class="overlay" id="overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">ADMIN DASHBOARD</div>
        <div class="sidebar-menu">
            <a href="/admin/admin_dashboard.php" class="menu-item active">
                <i class="fas fa-th-large"></i>
                <span>Dashboard</span>
            </a>
            <a href="/admin/coin-deposit-request.php" class="menu-item">
                <i class="fas fa-arrow-circle-down"></i>
                <span>Deposit Coin</span>
            </a>
             <a href="/admin/deposit_requests.php" class="menu-item">
                <i class="fas fa-money-check-alt"></i>
                <span>Deposit Check</span>
            </a>
            <a href="/admin/transfer-request.php" class="menu-item">
                <i class="fas fa-arrow-circle-up"></i>
                <span>Withdraw</span>
            </a>
            <a href="/admin/manage-payment-method.php" class="menu-item">
                <i class="fas fa-exchange-alt"></i>
                <span>Manage Payment Method</span>
            </a>
            <a href="/admin/admin_staking.php" class="menu-item">
                <i class="fas fa-lock"></i>
                <span>Manage Staking</span>
            </a>
            <a href="/admin/admin_staking_transactions.php" class="menu-item">
                <i class="fas fa-lock"></i>
                <span>Manage Staking Transations</span>
            </a>
            <a href="/admin/admin_stocks.php" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Manage Stocks</span>
            </a>
            <a href="/admin/admin_stock_transactions.php" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Manage Stocks Transations</span>
            </a>
            <a href="/admin/admin_bots.php" class="menu-item">
                <i class="fas fa-robot"></i>
                <span>Manage Bot</span>
            </a>
            <a href="/admin/investment.php" class="menu-item">
                <i class="fas fa-coins"></i>
                <span>Manage Investment</span>
            </a>
            
            <a href="/admin/crypto_orders.php" class="menu-item">
                <i class="fas fa-coins"></i>
                <span>Manage Crypto Order</span>
            </a>
            
            <a href="/admin/update_balance.php" class="menu-item">
                <i class="fas fa-file-invoice-dollar"></i>
                <span>Update Balances</span>
            </a>
            <a href="/admin/kyc-request.php" class="menu-item">
                <i class="fas fa-id-card"></i>
                <span>KYC</span>
            </a>
            <a href="/admin/admin_send_notification.php" class="menu-item">
                <i class="fas fa-bell"></i>
                <span>Manage Notifications</span>
            </a>

            <div class="section-title">USER MANAGEMENT</div>
            <a href="/admin/manage_users.php" class="menu-item">
                <i class="fas fa-users"></i>
                <span>Manage Users</span>
            </a>
            <div class="section-title">Approve SignUp</div>
            <a href="/admin/admin_approval.php" class="menu-item">
                <i class="fas fa-user-check"></i>
                <span>Approve SignUp</span>
            </a>
            <div class="section-title">Change Password</div>
            <a href="/admin/change_password.php" class="menu-item">
                <i class="fas fa-unlock-alt"></i>
                <span>Change Password</span>
            </a>

            <div class="section-title">MANAGEMENT</div>
            <a href="/admin/logout.php" class="menu-item">
                <i class="fas fa-sign-out"></i>
                <span>Sign Out</span>
            </a>
        </div>
    </div>


    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <div class="top-bar">
            <div class="page-icon">
                <i class="fas fa-clipboard"></i>
            </div>
            <div class="user-info">
                <div class="user-icon">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-role">
                    <div>Admin</div>
                    <div class="role-name">Administrator <i class="fas fa-chevron-down"></i></div>
                </div>
            </div>
        </div>

        <!-- Overview Section -->
        <div class="overview-section">
            <div class="overview-header">
                <div>
                    <h2 class="overview-title">Overview</h2>
                    <p class="overview-description">Here is an insight of what's going on.</p>
                </div>
                <button class="view-users-btn">
                    <i class="fas fa-users"></i> View All Users
                </button>
            </div>

   <div class="container">
    <h1>Check Deposit Administration</h1>

    <!-- Table Layout for Desktop -->
<!-- Table Layout for Desktop -->
<div class="table-wrapper">
    <table class="deposit-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Amount</th>
                <th>Account</th>
                <th>Images</th>
                <th>Status</th>
                <th>Date</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($deposits as $deposit): ?>
            <tr>
                <td><?php echo $deposit['id']; ?></td>
                <td><?php echo htmlspecialchars($deposit['username']); ?></td>
                <td>$<?php echo number_format($deposit['amount'], 2); ?></td>
                <td><?php echo ucfirst($deposit['account_type']); ?></td>
                <td>
                    <a href="#" onclick="showImage('/<?php echo $deposit['front_image']; ?>', 'Front Image')">Front</a> |
                    <a href="#" onclick="showImage('/<?php echo $deposit['back_image']; ?>', 'Back Image')">Back</a>
                </td>
                <td class="status-<?php echo $deposit['status']; ?>">
                    <?php echo ucfirst($deposit['status']); ?>
                </td>
                <td><?php echo date('M j, Y', strtotime($deposit['created_at'])); ?></td>
                <td>
                    <?php if ($deposit['status'] === 'pending'): ?>
                    <form method="POST" style="display: inline;">
                        <input type="hidden" name="deposit_id" value="<?php echo $deposit['id']; ?>">
                        <button type="submit" name="status" value="completed" class="btn-success">
                            Approve
                        </button>
                        <button type="submit" name="status" value="failed" class="btn-danger">
                            Reject
                        </button>
                    </form>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Cards Layout for Mobile -->
<div class="deposit-cards">
    <?php foreach ($deposits as $deposit): ?>
    <div class="deposit-card">
        <h3>Deposit ID: <?php echo $deposit['id']; ?></h3>
        <p><strong>Username:</strong> <?php echo htmlspecialchars($deposit['username']); ?></p>
        <p><strong>Amount:</strong> $<?php echo number_format($deposit['amount'], 2); ?></p>
        <p><strong>Account:</strong> <?php echo ucfirst($deposit['account_type']); ?></p>
        <p><strong>Status:</strong> <?php echo ucfirst($deposit['status']); ?></p>
        <p><strong>Date:</strong> <?php echo date('M j, Y', strtotime($deposit['created_at'])); ?></p>
        <p>
            <a href="#" onclick="showImage('/bank/<?php echo $deposit['front_image']; ?>', 'Front Image')">Front Image</a> |
            <a href="#" onclick="showImage('/bank/<?php echo $deposit['back_image']; ?>', 'Back Image')">Back Image</a>
        </p>
        <?php if ($deposit['status'] === 'pending'): ?>
        <form method="POST" style="display: inline;">
            <input type="hidden" name="deposit_id" value="<?php echo $deposit['id']; ?>">
            <button type="submit" name="status" value="completed" class="btn-success">
                Approve
            </button>
            <button type="submit" name="status" value="failed" class="btn-danger">
                Reject
            </button>
        </form>
        <?php endif; ?>
    </div>
    <?php endforeach; ?>
</div>

<!-- Enhanced Image Modal -->
<div id="imageModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <span id="imageTitle"></span>
            <span class="close">&times;</span>
        </div>
        <div class="modal-body">
            <img id="modalImage" src="" alt="Check image">
        </div>
        <div class="modal-footer">
            <button id="downloadBtn" class="btn-download">
                <i class="fas fa-download"></i> Download
            </button>
            <button class="btn-close" onclick="closeModal()">
                <i class="fas fa-times"></i> Close
            </button>
        </div>
    </div>
</div>

<style>
/* Enhanced Modal Styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1100;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0,0,0,0.9);
    animation: fadeIn 0.3s;
}

.modal-content {
    position: relative;
    margin: auto;
    width: 90%;
    max-width: 800px;
    height: 90%;
    max-height: 90vh;
    top: 50%;
    transform: translateY(-50%);
    background: #fff;
    border-radius: 8px;
    display: flex;
    flex-direction: column;
    overflow: hidden;
}

.modal-header {
    padding: 15px 20px;
    background: #f8f9fa;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
}

#imageTitle {
    font-weight: 600;
    color: #333;
}

.modal-body {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
    overflow: auto;
}

.modal-body img {
    max-width: 100%;
    max-height: 100%;
    object-fit: contain;
    border-radius: 4px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.modal-footer {
    padding: 15px 20px;
    background: #f8f9fa;
    display: flex;
    justify-content: flex-end;
    gap: 10px;
    border-top: 1px solid #eee;
}

.close {
    color: #aaa;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
    transition: color 0.2s;
}

.close:hover {
    color: #333;
}

.btn-download, .btn-close {
    padding: 8px 16px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    transition: all 0.2s;
}

.btn-download {
    background-color: #2ecc71;
    color: white;
}

.btn-download:hover {
    background-color: #27ae60;
}

.btn-close {
    background-color: #e74c3c;
    color: white;
}

.btn-close:hover {
    background-color: #c0392b;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

/* Responsive adjustments for modal */
@media (max-width: 768px) {
    .modal-content {
        width: 95%;
        height: 95%;
    }
    
    .modal-body {
        padding: 10px;
    }
    
    .btn-download, .btn-close {
        padding: 8px 12px;
        font-size: 13px;
    }
}

/* Rest of your existing styles... */
/* Deposit Administration Styles */
.container {
    background-color: var(--card-bg);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 20px;
    margin-bottom: 20px;
}

.container h1 {
    font-size: 24px;
    color: var(--primary-text);
    margin-bottom: 20px;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}

/* Table Styles */
.table-wrapper {
    overflow-x: auto;
    margin-bottom: 20px;
    -webkit-overflow-scrolling: touch;
}

.deposit-table {
    width: 100%;
    border-collapse: collapse;
}

.deposit-table th, 
.deposit-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #eee;
}

.deposit-table th {
    background-color: #f8f9fa;
    color: var(--primary-text);
    font-weight: 500;
    position: sticky;
    top: 0;
}

.deposit-table tr:hover {
    background-color: #f8f9fa;
}

/* Status Badges */
.status-pending {
    color: #f39c12;
    font-weight: 500;
}

.status-completed {
    color: #2ecc71;
    font-weight: 500;
}

.status-failed {
    color: #e74c3c;
    font-weight: 500;
}

/* Button Styles */
.btn-success {
    padding: 6px 12px;
    background-color: #2ecc71;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    transition: background-color 0.3s;
}

.btn-success:hover {
    background-color: #27ae60;
}

.btn-danger {
    padding: 6px 12px;
    background-color: #e74c3c;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    transition: background-color 0.3s;
}

.btn-danger:hover {
    background-color: #c0392b;
}

/* Image Links */
.deposit-table a {
    color: var(--button-color);
    text-decoration: none;
    transition: color 0.3s;
}

.deposit-table a:hover {
    color: var(--hover-color);
    text-decoration: underline;
}

/* Mobile Cards */
.deposit-cards {
    display: none;
    grid-template-columns: 1fr;
    gap: 15px;
}

.deposit-card {
    background-color: var(--card-bg);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 15px;
    border: 1px solid #eee;
}

.deposit-card h3 {
    font-size: 18px;
    margin-bottom: 10px;
    color: var(--primary-text);
}

.deposit-card p {
    margin-bottom: 8px;
    font-size: 14px;
    color: var(--secondary-text);
}

.deposit-card strong {
    color: var(--primary-text);
}

.deposit-card a {
    color: var(--button-color);
    text-decoration: none;
}

.deposit-card a:hover {
    text-decoration: underline;
}

.deposit-card .btn-success,
.deposit-card .btn-danger {
    width: 100%;
    margin-top: 8px;
}

/* Responsive Adjustments */
@media (max-width: 768px) {
    .table-wrapper {
        display: none;
    }
    
    .deposit-cards {
        display: grid;
    }
}

@media (max-width: 576px) {
    .container {
        padding: 15px;
    }
    
    .deposit-card {
        padding: 12px;
    }
}
</style>

<script>
    // Current image URL for download
    let currentImageUrl = '';
    let currentImageTitle = '';
    
    // Function to display the modal with the image
    function showImage(imageUrl, title) {
        const modal = document.getElementById('imageModal');
        const modalImage = document.getElementById('modalImage');
        const imageTitle = document.getElementById('imageTitle');
        
        currentImageUrl = imageUrl;
        currentImageTitle = title;
        
        modal.style.display = "block";
        modalImage.src = imageUrl;
        imageTitle.textContent = title;
        document.body.style.overflow = 'hidden'; // Prevent scrolling
    }
    
    // Function to close the modal
    function closeModal() {
        document.getElementById('imageModal').style.display = "none";
        document.body.style.overflow = ''; // Re-enable scrolling
    }
    
    // Close the modal when clicking the X or outside the image
    document.querySelector('.close').onclick = closeModal;
    
    // Close modal when clicking outside the content
    window.onclick = function(event) {
        const modal = document.getElementById('imageModal');
        if (event.target === modal) {
            closeModal();
        }
    }
    
    // Handle download button click
    document.getElementById('downloadBtn').addEventListener('click', function() {
        if (currentImageUrl) {
            // Create a temporary anchor element
            const link = document.createElement('a');
            link.href = currentImageUrl;
            link.download = currentImageTitle.replace(/\s+/g, '_') + '_' + new Date().getTime() + '.jpg';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    });
    
    // Close modal when pressing Escape key
    document.addEventListener('keydown', function(event) {
        if (event.key === 'Escape') {
            closeModal();
        }
    });

    // Get references to elements
    const navToggle = document.getElementById('navToggle');
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('overlay');
    const mainContent = document.getElementById('mainContent');

    // Toggle sidebar
    navToggle.addEventListener('click', function() {
        sidebar.classList.toggle('active');
        overlay.classList.toggle('active');
    });

    // Close sidebar when clicking on overlay
    overlay.addEventListener('click', function() {
        sidebar.classList.remove('active');
        overlay.classList.remove('active');
    });

    // Close sidebar when clicking on main content (for mobile)
    mainContent.addEventListener('click', function() {
        if (window.innerWidth <= 768 && sidebar.classList.contains('active')) {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        }
    });

    // Handle window resize
    window.addEventListener('resize', function() {
        if (window.innerWidth > 768) {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        }
    });

    // Close sidebar when clicking menu items (for mobile)
    const menuItems = document.querySelectorAll('.menu-item');
    menuItems.forEach(item => {
        item.addEventListener('click', function() {
            if (window.innerWidth <= 768) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });
    });
</script>
</body>
</html>