<?php
session_start();
include($_SERVER['DOCUMENT_ROOT'] . '/config.php');
// Verify admin is logged in
if (!isset($_SESSION['admin_id']) || empty($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit();
}
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPMailer-master/src/PHPMailer.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPMailer-master/src/Exception.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHPMailer-master/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;


// Handle status update if form submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_status'])) {
    $depositId = $_POST['deposit_id'];
    $newStatus = $_POST['status'];
    $remarks = $_POST['remarks'] ?? '';

    try {
        // First get the deposit details and user email before updating
        $stmt = $conn->prepare("
            SELECT 
                d.*, 
                u.email, 
                u.username,
                pm.name AS payment_method_name
            FROM 
                deposits d 
            JOIN 
                users u ON d.user_id = u.id
            JOIN
                payment_methods pm ON d.payment_method = pm.id
            WHERE 
                d.id = ?
        ");
        $stmt->execute([$depositId]);
        $deposit = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!$deposit) {
            throw new Exception("Deposit not found");
        }

        // Update the deposit status
        $stmt = $conn->prepare("UPDATE deposits SET status = ?, remarks = ? WHERE id = ?");
        $stmt->execute([$newStatus, $remarks, $depositId]);

        // If status is completed, update user balance
        if ($newStatus === 'completed') {
            $stmt = $conn->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
            $stmt->execute([$deposit['amount'], $deposit['user_id']]);
        }

        // Send status update email
        $mail = new PHPMailer(true);
        try {
            // SMTP Configuration
            $mail->isSMTP();
            $mail->Host = 'server108.web-hosting.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'time@parcelpulsex.xyz';
            $mail->Password = 'Omotoyosi8';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
            $mail->Port = 587;

            // Recipients
            $mail->setFrom('time@parcelpulsex.xyz', 'Pocket Wallet');
            $mail->addAddress($deposit['email']);
            $mail->isHTML(true);
            
            // Determine status color and message
            $statusColor = '#6366f1'; // Default purple
            $statusMessage = 'Processed';
            
            if ($newStatus === 'completed') {
                $statusColor = '#10b981'; // Green
                $statusMessage = 'Completed Successfully';
            } elseif ($newStatus === 'cancelled') {
                $statusColor = '#ef4444'; // Red
                $statusMessage = 'Cancelled';
            }
            
            // Email content
            $mail->Subject = 'Deposit Status Update - Pocket Wallet';
            $mail->Body = "
            <!DOCTYPE html>
            <html>
            <head>
                <style>
                    body { font-family: 'Segoe UI', Tahoma, sans-serif; background-color: #f5f5f9; margin: 0; padding: 0; color: #333; }
                    .email-container { max-width: 600px; margin: 0 auto; background: #fff; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 20px rgba(0,0,0,0.1); }
                    .email-header { background: #6366f1; padding: 30px; text-align: center; color: white; }
                    .email-content { padding: 30px; }
                    .transaction-details { background: #f3f4f6; border-radius: 8px; padding: 15px; margin: 20px 0; }
                    .status-badge { display: inline-block; padding: 5px 15px; border-radius: 20px; color: white; background: $statusColor; font-weight: bold; }
                    .security-note { background: #fff3f3; border-left: 4px solid #ff6b6b; padding: 15px; margin: 20px 0; font-size: 14px; }
                    .email-footer { background: #23232f; color: #a0a0a0; padding: 20px; text-align: center; font-size: 12px; }
                </style>
            </head>
            <body>
                <div class='email-container'>
                    <div class='email-header'>
                        <h1>Pocket Wallet</h1>
                        <p>Secure Crypto Management</p>
                    </div>
                    <div class='email-content'>
                        <h2>Deposit Status Update</h2>
                        <p>Hello ".htmlspecialchars($deposit['username'], ENT_QUOTES, 'UTF-8').",</p>
                        <p>Your deposit request has been updated:</p>
                        <div class='transaction-details'>
                            <p><strong>Transaction ID:</strong> ".htmlspecialchars($deposit['transaction_id'], ENT_QUOTES, 'UTF-8')."</p>
                            <p><strong>Amount:</strong> ".htmlspecialchars($deposit['amount'], ENT_QUOTES, 'UTF-8')." ".htmlspecialchars($deposit['currency'], ENT_QUOTES, 'UTF-8')."</p>
                            <p><strong>Payment Method:</strong> ".htmlspecialchars($deposit['payment_method_name'], ENT_QUOTES, 'UTF-8')."</p>
                            <p><strong>Status:</strong> <span class='status-badge'>$statusMessage</span></p>
                            ".($remarks ? "<p><strong>Remarks:</strong> ".htmlspecialchars($remarks, ENT_QUOTES, 'UTF-8')."</p>" : "")."
                        </div>
                        ".($newStatus === 'completed' ? 
                            "<p>The funds have been credited to your account balance.</p>" : 
                            "<p>If you have any questions about this decision, please contact our support team.</p>")."
                        <div class='security-note'>
                            <p><strong>Security Notice:</strong> If you didn't initiate this deposit, please contact our support team immediately.</p>
                        </div>
                    </div>
                    <div class='email-footer'>
                        <p>&copy; ".date('Y')." Pocket Wallet. All rights reserved.</p>
                    </div>
                </div>
            </body>
            </html>";

            $mail->send();
            $_SESSION['admin_message'] = "Deposit status updated and user notified successfully.";
        } catch (Exception $e) {
            error_log("Deposit status email failed: " . $e->getMessage());
            $_SESSION['admin_message'] = "Deposit status updated but email notification failed.";
        }

        header("Location: admin_deposits.php");
        exit;

    } catch (Exception $e) {
        $_SESSION['admin_error'] = "Error: " . $e->getMessage();
        header("Location: admin_deposits.php");
        exit;
    }
}

// Fetch Deposit Requests
try {
    $deposits = $conn->query("
        SELECT 
            d.*, 
            u.username AS username,
            pm.name AS payment_method_name
        FROM 
            deposits d 
        JOIN 
            users u 
        ON 
            d.user_id = u.id
        JOIN
            payment_methods pm
        ON
            d.payment_method = pm.id
        ORDER BY
            d.created_at DESC
    ")->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Failed to fetch deposit requests: " . $e->getMessage());
}

// Function to get status color class
function getStatusClass($status) {
    switch($status) {
        case 'completed':
            return 'status-completed';
        case 'pending':
            return 'status-pending';
        case 'cancelled':
            return 'status-cancelled';
        default:
            return '';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }

        :root {
            --sidebar-bg: #14213d;
            --sidebar-text: #a8b2d1;
            --sidebar-hover: #1a2c5b;
            --active-link: #2a4494;
            --primary-text: #333;
            --secondary-text: #777;
            --card-bg: #fff;
            --main-bg: #f0f2f5;
            --deposit-color: #3498db;
            --withdraw-color: #e74c3c;
            --button-color: #0d6efd;
            --hover-color: #0b5ed7;
        }

        body {
            display: flex;
            background-color: var(--main-bg);
            min-height: 100vh;
        }

        /* Mobile nav toggle */
        .mobile-nav-toggle {
            display: none;
            position: fixed;
            top: 15px;
            left: 15px;
            z-index: 1050;
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            width: 40px;
            height: 40px;
            border-radius: 4px;
            justify-content: center;
            align-items: center;
            cursor: pointer;
            border: none;
            font-size: 20px;
        }

        /* Overlay for mobile */
        .overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 900;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 250px;
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            height: 100vh;
            position: fixed;
            transition: all 0.3s ease;
            overflow-y: auto;
            z-index: 1000;
        }

        .sidebar-header {
            padding: 20px;
            font-size: 18px;
            font-weight: bold;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .sidebar-menu {
            margin-top: 20px;
        }

        .section-title {
            padding: 10px 20px;
            font-size: 12px;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #8a94a7;
            margin-top: 10px;
        }

        .menu-item {
            display: flex;
            align-items: center;
            padding: 12px 20px;
            text-decoration: none;
            color: var(--sidebar-text);
            transition: all 0.3s ease;
        }

        .menu-item:hover {
            background-color: var(--sidebar-hover);
        }

        .menu-item.active {
            background-color: var(--active-link);
            color: white;
        }

        .menu-item i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }

        /* Main Content */
        .main-content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
            width: calc(100% - 250px);
            transition: all 0.3s ease;
        }

        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .page-icon {
            font-size: 20px;
            color: var(--primary-text);
        }

        .user-info {
            display: flex;
            align-items: center;
        }

        .user-icon {
            width: 32px;
            height: 32px;
            background-color: var(--button-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            margin-right: 10px;
        }

        .user-role {
            display: flex;
            flex-direction: column;
        }

        .role-name {
            font-size: 12px;
            color: var(--secondary-text);
        }

        /* Overview Section */
        .overview-section {
            margin-bottom: 30px;
        }

        .overview-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }

        .overview-title {
            font-size: 24px;
            font-weight: 500;
            color: var(--primary-text);
        }

        .overview-description {
            font-size: 14px;
            color: var(--secondary-text);
            margin-top: 5px;
        }

        .view-users-btn {
            padding: 8px 16px;
            background-color: var(--button-color);
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: background-color 0.3s;
        }

        .view-users-btn:hover {
            background-color: var(--hover-color);
        }

        .view-users-btn i {
            margin-right: 6px;
        }

        /* Cards Grid */
        .cards-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .card {
            background-color: var(--card-bg);
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            padding: 20px;
            position: relative;
        }

        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }

        .card-title {
            font-size: 16px;
            color: var(--primary-text);
        }

        .card-icon {
            font-size: 14px;
            color: var(--secondary-text);
            cursor: pointer;
        }

        .card-amount {
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 20px;
        }

        .deposit-bar {
            height: 4px;
            width: 100%;
            background-color: var(--deposit-color);
            border-radius: 2px;
        }

        .withdraw-bar {
            height: 4px;
            width: 100%;
            background-color: var(--withdraw-color);
            border-radius: 2px;
        }

        /* Stats Card */
        .stats-card {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 20px;
        }

        .stat-item {
            margin-bottom: 15px;
        }

        .stat-label {
            display: flex;
            align-items: center;
            margin-bottom: 5px;
            font-size: 14px;
            color: var(--secondary-text);
        }

        .stat-label-circle {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            margin-right: 8px;
        }

        .deposit-circle {
            background-color: #f39c12;
        }

        .withdraw-circle {
            background-color: #e74c3c;
        }

        .transaction-circle {
            background-color: #9b59b6;
        }

        .users-circle {
            background-color: #3498db;
        }

        .stat-value {
            font-size: 24px;
            font-weight: 500;
        }

        /* Footer */
        .footer {
            font-size: 12px;
            color: var(--secondary-text);
            margin-top: 40px;
            padding-top: 10px;
            border-top: 1px solid #eee;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .sidebar {
                width: 80px;
            }
            .sidebar-header {
                padding: 15px 10px;
                text-align: center;
                font-size: 14px;
            }
            .menu-item span, .section-title {
                display: none;
            }
            .menu-item {
                justify-content: center;
                padding: 15px 0;
            }
            .menu-item i {
                margin-right: 0;
                font-size: 18px;
            }
            .main-content {
                margin-left: 80px;
                width: calc(100% - 80px);
            }
        }

        @media (max-width: 768px) {
            .cards-grid {
                grid-template-columns: 1fr;
            }
            .stats-card {
                grid-template-columns: 1fr;
            }
            .mobile-nav-toggle {
                display: flex;
            }
            .sidebar {
                transform: translateX(-100%);
                width: 250px;
            }
            .sidebar.active {
                transform: translateX(0);
            }
            .menu-item span, .section-title {
                display: block;
            }
            .menu-item {
                justify-content: flex-start;
                padding: 12px 20px;
            }
            .menu-item i {
                margin-right: 10px;
            }
            .main-content {
                margin-left: 0;
                width: 100%;
                padding-top: 60px;
            }
            .overlay.active {
                display: block;
            }
        }

        @media (max-width: 576px) {
            .overview-header {
                flex-direction: column;
                align-items: flex-start;
            }
            .view-users-btn {
                margin-top: 10px;
            }
        }
    </style>
</head>
<body>
    <!-- Mobile menu toggle -->
    <button class="mobile-nav-toggle" id="navToggle">
        <i class="fas fa-bars"></i>
    </button>

               <!-- Overlay for closing the sidebar on mobile -->
    <div class="overlay" id="overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">ADMIN DASHBOARD</div>
        <div class="sidebar-menu">
            <a href="/admin/admin_dashboard.php" class="menu-item active">
                <i class="fas fa-th-large"></i>
                <span>Dashboard</span>
            </a>
            <a href="/admin/coin-deposit-request.php" class="menu-item">
                <i class="fas fa-arrow-circle-down"></i>
                <span>Deposit Coin</span>
            </a>
             <a href="/admin/deposit_requests.php" class="menu-item">
                <i class="fas fa-money-check-alt"></i>
                <span>Deposit Check</span>
            </a>
            <a href="/admin/transfer-request.php" class="menu-item">
                <i class="fas fa-arrow-circle-up"></i>
                <span>Withdraw</span>
            </a>
            <a href="/admin/manage-payment-method.php" class="menu-item">
                <i class="fas fa-exchange-alt"></i>
                <span>Manage Payment Method</span>
            </a>
            <a href="/admin/admin_staking.php" class="menu-item">
                <i class="fas fa-lock"></i>
                <span>Manage Staking</span>
            </a>
            <a href="/admin/admin_staking_transactions.php" class="menu-item">
                <i class="fas fa-lock"></i>
                <span>Manage Staking Transations</span>
            </a>
            <a href="/admin/admin_stocks.php" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Manage Stocks</span>
            </a>
            <a href="/admin/admin_stock_transactions.php" class="menu-item">
                <i class="fas fa-chart-bar"></i>
                <span>Manage Stocks Transations</span>
            </a>
            <a href="/admin/admin_bots.php" class="menu-item">
                <i class="fas fa-robot"></i>
                <span>Manage Bot</span>
            </a>
            <a href="/admin/investment.php" class="menu-item">
                <i class="fas fa-coins"></i>
                <span>Manage Investment</span>
            </a>
            
            <a href="/admin/crypto_orders.php" class="menu-item">
                <i class="fas fa-coins"></i>
                <span>Manage Crypto Order</span>
            </a>
            
            <a href="/admin/update_balance.php" class="menu-item">
                <i class="fas fa-file-invoice-dollar"></i>
                <span>Update Balances</span>
            </a>
            <a href="/admin/kyc-request.php" class="menu-item">
                <i class="fas fa-id-card"></i>
                <span>KYC</span>
            </a>
            <a href="/admin/admin_send_notification.php" class="menu-item">
                <i class="fas fa-bell"></i>
                <span>Manage Notifications</span>
            </a>

            <div class="section-title">USER MANAGEMENT</div>
            <a href="/admin/manage_users.php" class="menu-item">
                <i class="fas fa-users"></i>
                <span>Manage Users</span>
            </a>
            <div class="section-title">Approve SignUp</div>
            <a href="/admin/admin_approval.php" class="menu-item">
                <i class="fas fa-user-check"></i>
                <span>Approve SignUp</span>
            </a>
            <div class="section-title">Change Password</div>
            <a href="/admin/change_password.php" class="menu-item">
                <i class="fas fa-unlock-alt"></i>
                <span>Change Password</span>
            </a>

            <div class="section-title">MANAGEMENT</div>
            <a href="/admin/logout.php" class="menu-item">
                <i class="fas fa-sign-out"></i>
                <span>Sign Out</span>
            </a>
        </div>
    </div>


    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <div class="top-bar">
            <div class="page-icon">
                <i class="fas fa-clipboard"></i>
            </div>
            <div class="user-info">
                <div class="user-icon">
                    <i class="fas fa-user"></i>
                </div>
                <div class="user-role">
                    <div>Admin</div>
                    <div class="role-name">Administrator <i class="fas fa-chevron-down"></i></div>
                </div>
            </div>
        </div>

        <!-- Overview Section -->
        <div class="overview-section">
            <div class="overview-header">
                <div>
                    <h2 class="overview-title">Overview</h2>
                    <p class="overview-description">Here is an insight of what's going on.</p>
                </div>
                <button class="view-users-btn">
                    <i class="fas fa-users"></i> View All Users
                </button>
            </div>

    <style>
        /* Add this CSS to your existing styles */
.container {
    background-color: var(--card-bg);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 20px;
    margin-bottom: 20px;
}

.container h6 {
    font-size: 18px;
    color: var(--primary-text);
    margin-bottom: 15px;
    padding-bottom: 10px;
    border-bottom: 1px solid #eee;
}

/* Table styling for desktop */
table {
    width: 100%;
    border-collapse: collapse;
    margin-bottom: 20px;
}

table th, 
table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #eee;
}

table th {
    background-color: #f8f9fa;
    color: var(--primary-text);
    font-weight: 500;
    position: sticky;
    top: 0;
}

table tr:hover {
    background-color: #f8f9fa;
}

/* Status colors */
.status-pending {
    color: #f39c12;
    font-weight: 500;
}

.status-completed {
    color: #2ecc71;
    font-weight: 500;
}

.status-cancelled {
    color: #e74c3c;
    font-weight: 500;
}

/* Form elements */
form {
    display: flex;
    gap: 8px;
    align-items: center;
}

select {
    padding: 6px 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-family: inherit;
}

button[type="submit"] {
    padding: 6px 12px;
    background-color: var(--button-color);
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    transition: background-color 0.3s;
}

button[type="submit"]:hover {
    background-color: var(--hover-color);
}

/* Mobile cards - hidden by default */
.deposit-cards {
    display: none;
    grid-template-columns: 1fr;
    gap: 15px;
}

.deposit-card {
    background-color: var(--card-bg);
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    padding: 15px;
    border: 1px solid #eee;
}

.deposit-card p {
    margin-bottom: 8px;
    font-size: 14px;
    color: var(--secondary-text);
}

.deposit-card strong {
    color: var(--primary-text);
}

.deposit-card .status {
    font-weight: 500;
}

.deposit-card form {
    margin-top: 10px;
    flex-direction: column;
    align-items: stretch;
}

.deposit-card select,
.deposit-card button {
    width: 100%;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    table {
        display: none;
    }
    
    .deposit-cards {
        display: grid;
    }
}

@media (max-width: 576px) {
    .container {
        padding: 15px;
    }
    
    .deposit-card {
        padding: 12px;
    }
}
    </style>
</head>
<body>
    <div class="container">
        <h6>Deposit Requests</h6>
        <table>
            <thead>
                <tr>
                    <th>User Name</th>
                    <th>User ID</th>
                    <th>Amount</th>
                    <th>Payment Method</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($deposits as $deposit): ?>
                    <tr>
                        <td><?= htmlspecialchars($deposit['username']); ?></td>
                        <td><?= htmlspecialchars($deposit['user_id']); ?></td>
                        <td><?= htmlspecialchars($deposit['amount']); ?></td>
                        <td><?= htmlspecialchars($deposit['payment_method_name']); ?></td>
                        <td class="<?= getStatusClass($deposit['status']); ?>"><?= ucfirst(htmlspecialchars($deposit['status'])); ?></td>
                        <td>
                            <form method="POST" action="update_status.php">
                                <input type="hidden" name="id" value="<?= htmlspecialchars($deposit['id']); ?>">
                                <select name="status">
                                    <option value="pending" <?= $deposit['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                    <option value="completed" <?= $deposit['status'] == 'completed' ? 'selected' : ''; ?>>Completed</option>
                                    <option value="cancelled" <?= $deposit['status'] == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
                                </select>
                                <button type="submit">Update</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="deposit-cards">
    <?php foreach ($deposits as $deposit): ?>
    <div class="deposit-card">
        <p><strong>User:</strong> <?= htmlspecialchars($deposit['username']); ?></p>
        <p><strong>User ID:</strong> <?= htmlspecialchars($deposit['user_id']); ?></p>
        <p><strong>Amount:</strong> <?= htmlspecialchars($deposit['amount']); ?></p>
        <p><strong>Method:</strong> <?= htmlspecialchars($deposit['payment_method_name']); ?></p>
        <p><strong>Status:</strong> 
            <span class="status <?= getStatusClass($deposit['status']); ?>">
                <?= ucfirst(htmlspecialchars($deposit['status'])); ?>
            </span>
        </p>
        
        <form method="POST" action="update_status.php">
            <input type="hidden" name="id" value="<?= htmlspecialchars($deposit['id']); ?>">
            <select name="status">
                <option value="pending" <?= $deposit['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                <option value="completed" <?= $deposit['status'] == 'completed' ? 'selected' : ''; ?>>Completed</option>
                <option value="cancelled" <?= $deposit['status'] == 'cancelled' ? 'selected' : ''; ?>>Cancelled</option>
            </select>
            <button type="submit">Update Status</button>
        </form>
    </div>
    <?php endforeach; ?>
</div>
     <!-- Footer -->
        <div class="footer">
            Pocket © 2024. All rights reserved.
        </div>
    </div>

    <script>
        // Get references to elements
        const navToggle = document.getElementById('navToggle');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('overlay');
        const mainContent = document.getElementById('mainContent');

        // Toggle sidebar
        navToggle.addEventListener('click', function() {
            sidebar.classList.toggle('active');
            overlay.classList.toggle('active');
        });

        // Close sidebar when clicking on overlay
        overlay.addEventListener('click', function() {
            sidebar.classList.remove('active');
            overlay.classList.remove('active');
        });

        // Close sidebar when clicking on main content (for mobile)
        mainContent.addEventListener('click', function() {
            if (window.innerWidth <= 768 && sidebar.classList.contains('active')) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });

        // Handle window resize
        window.addEventListener('resize', function() {
            if (window.innerWidth > 768) {
                sidebar.classList.remove('active');
                overlay.classList.remove('active');
            }
        });

        // Close sidebar when clicking menu items (for mobile)
        const menuItems = document.querySelectorAll('.menu-item');
        menuItems.forEach(item => {
            item.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                }
            });
        });
    </script>
</body>
</html>