document.addEventListener("DOMContentLoaded", function() {
    loadActiveChats(); // Load active chats when the page is ready

    // Listen for the send reply button
    document.getElementById('send-admin-reply').addEventListener('click', function() {
        const replyMessage = document.getElementById('admin-chat-input').value;
        const chatId = document.getElementById('chat-window').getAttribute('data-chat-id');
        
        if (replyMessage.trim()) {
            sendAdminReply(chatId, replyMessage);
            document.getElementById('admin-chat-input').value = ''; // Clear the input field
        }
    });

    // Mark chat as resolved
    document.getElementById('mark-resolved').addEventListener('click', function() {
        const chatId = document.getElementById('chat-window').getAttribute('data-chat-id');
        markChatAsResolved(chatId);
    });
});

// Load active chats
function loadActiveChats() {
    let xhr = new XMLHttpRequest();
    xhr.open('GET', 'load_active_chats.php', true);
    xhr.onload = function() {
        if (xhr.status === 200) {
            const activeChats = JSON.parse(xhr.responseText);
            const chatList = document.getElementById('active-chats-list');
            chatList.innerHTML = '';

            activeChats.forEach(chat => {
                const listItem = document.createElement('li');
                listItem.innerHTML = `<a href="#" onclick="loadChatHistory(${chat.chat_id})">Chat with User ${chat.user_id}</a>`;
                chatList.appendChild(listItem);
            });
        }
    };
    xhr.send();
}

// Load chat history for a specific chat
function loadChatHistory(chatId) {
    let xhr = new XMLHttpRequest();
    xhr.open('GET', 'load_chat_history.php?chat_id=' + chatId, true);
    xhr.onload = function() {
        if (xhr.status === 200) {
            const chatHistory = xhr.responseText;
            document.getElementById('chat-box').innerHTML = chatHistory;
            document.getElementById('chat-window').setAttribute('data-chat-id', chatId);
        }
    };
    xhr.send();
}

// Send reply to user (admin response)
function sendAdminReply(chatId, replyMessage) {
    let xhr = new XMLHttpRequest();
    xhr.open('POST', 'send_admin_reply.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            document.getElementById('chat-box').innerHTML += `<p>Admin: ${replyMessage}</p>`;
        }
    };
    xhr.send(`chat_id=${chatId}&message=${encodeURIComponent(replyMessage)}`);
}

// Mark chat as resolved
function markChatAsResolved(chatId) {
    let xhr = new XMLHttpRequest();
    xhr.open('POST', 'mark_chat_resolved.php', true);
    xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    xhr.onload = function() {
        if (xhr.status === 200) {
            alert("Chat marked as resolved.");
            // Reload the active chats list
            loadActiveChats();
        }
    };
    xhr.send(`chat_id=${chatId}`);
}
