<?php
// Database configuration
$host = 'localhost';
$dbname = 'parclvda_crypto_wallet';
$username = 'parclvda_crypto_wallet';
$password = 'Omotoyosi8';

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 0); // Set to 1 for development, 0 for production
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');

// Session management
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'cookie_secure' => true,    // Requires HTTPS
        'cookie_httponly' => true,  // Prevents JavaScript access
        'use_strict_mode' => true   // Prevents session fixation
    ]);
}

// Authentication check (remove auto-login in production)
if (!isset($_SESSION['user_id'])) {
    // header('Location: login.php'); // Uncomment in production
    // exit();
    $_SESSION['user_id'] = 1; // Remove this line in production
}

// Database connection
try {
    $pdo = new PDO(
        "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
        $username,
        $password,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
    
    // Make connection available globally
    $GLOBALS['pdo'] = $pdo;
    
} catch (PDOException $e) {
    error_log("Database connection failed: " . $e->getMessage());
    die("Database connection error. Please try again later.");
}
?>